/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class WriteResponseBase
implements JsonpSerializable {
    private final String id;
    private final String index;
    private final long primaryTerm;
    private final Result result;
    private final int seqNo;
    private final ShardStatistics shards;
    @Nullable
    private final String type;
    private final long version;
    @Nullable
    private final Boolean forcedRefresh;

    public WriteResponseBase(AbstractBuilder<?> builder) {
        this.id = Objects.requireNonNull(((AbstractBuilder)builder).id, "_id");
        this.index = Objects.requireNonNull(((AbstractBuilder)builder).index, "_index");
        this.primaryTerm = Objects.requireNonNull(((AbstractBuilder)builder).primaryTerm, "_primary_term");
        this.result = Objects.requireNonNull(((AbstractBuilder)builder).result, "result");
        this.seqNo = Objects.requireNonNull(((AbstractBuilder)builder).seqNo, "_seq_no");
        this.shards = Objects.requireNonNull(((AbstractBuilder)builder).shards, "_shards");
        this.type = ((AbstractBuilder)builder).type;
        this.version = Objects.requireNonNull(((AbstractBuilder)builder).version, "_version");
        this.forcedRefresh = ((AbstractBuilder)builder).forcedRefresh;
    }

    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    public long primaryTerm() {
        return this.primaryTerm;
    }

    public Result result() {
        return this.result;
    }

    public int seqNo() {
        return this.seqNo;
    }

    public ShardStatistics shards() {
        return this.shards;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    public long version() {
        return this.version;
    }

    @Nullable
    public Boolean forcedRefresh() {
        return this.forcedRefresh;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        generator.writeKey("_primary_term");
        generator.write(this.primaryTerm);
        generator.writeKey("result");
        this.result.serialize(generator, mapper);
        generator.writeKey("_seq_no");
        generator.write(this.seqNo);
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        if (this.type != null) {
            generator.writeKey("_type");
            generator.write(this.type);
        }
        generator.writeKey("_version");
        generator.write(this.version);
        if (this.forcedRefresh != null) {
            generator.writeKey("forced_refresh");
            generator.write(this.forcedRefresh.booleanValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupWriteResponseBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(AbstractBuilder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
        op.add(AbstractBuilder::primaryTerm, JsonpDeserializer.longDeserializer(), "_primary_term", new String[0]);
        op.add(AbstractBuilder::result, Result._DESERIALIZER, "result", new String[0]);
        op.add(AbstractBuilder::seqNo, JsonpDeserializer.integerDeserializer(), "_seq_no", new String[0]);
        op.add(AbstractBuilder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
        op.add(AbstractBuilder::type, JsonpDeserializer.stringDeserializer(), "_type", new String[0]);
        op.add(AbstractBuilder::version, JsonpDeserializer.longDeserializer(), "_version", new String[0]);
        op.add(AbstractBuilder::forcedRefresh, JsonpDeserializer.booleanDeserializer(), "forced_refresh", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        private String id;
        private String index;
        private Long primaryTerm;
        private Result result;
        private Integer seqNo;
        private ShardStatistics shards;
        @Nullable
        private String type;
        private Long version;
        @Nullable
        private Boolean forcedRefresh;

        protected AbstractBuilder() {
        }

        public BuilderT id(String value) {
            this.id = value;
            return this.self();
        }

        public BuilderT index(String value) {
            this.index = value;
            return this.self();
        }

        public BuilderT primaryTerm(long value) {
            this.primaryTerm = value;
            return this.self();
        }

        public BuilderT result(Result value) {
            this.result = value;
            return this.self();
        }

        public BuilderT seqNo(int value) {
            this.seqNo = value;
            return this.self();
        }

        public BuilderT shards(ShardStatistics value) {
            this.shards = value;
            return this.self();
        }

        public BuilderT shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public BuilderT type(@Nullable String value) {
            this.type = value;
            return this.self();
        }

        public BuilderT version(long value) {
            this.version = value;
            return this.self();
        }

        public BuilderT forcedRefresh(@Nullable Boolean value) {
            this.forcedRefresh = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

