/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class StoreStats
implements JsonpSerializable {
    @Nullable
    private final String size;
    private final int sizeInBytes;
    @Nullable
    private final String reserved;
    private final int reservedInBytes;
    @Nullable
    private final String totalDataSetSize;
    @Nullable
    private final Integer totalDataSetSizeInBytes;
    public static final JsonpDeserializer<StoreStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StoreStats::setupStoreStatsDeserializer, Builder::build);

    public StoreStats(Builder builder) {
        this.size = builder.size;
        this.sizeInBytes = Objects.requireNonNull(builder.sizeInBytes, "size_in_bytes");
        this.reserved = builder.reserved;
        this.reservedInBytes = Objects.requireNonNull(builder.reservedInBytes, "reserved_in_bytes");
        this.totalDataSetSize = builder.totalDataSetSize;
        this.totalDataSetSizeInBytes = builder.totalDataSetSizeInBytes;
    }

    public StoreStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String size() {
        return this.size;
    }

    public int sizeInBytes() {
        return this.sizeInBytes;
    }

    @Nullable
    public String reserved() {
        return this.reserved;
    }

    public int reservedInBytes() {
        return this.reservedInBytes;
    }

    @Nullable
    public String totalDataSetSize() {
        return this.totalDataSetSize;
    }

    @Nullable
    public Integer totalDataSetSizeInBytes() {
        return this.totalDataSetSizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
        if (this.reserved != null) {
            generator.writeKey("reserved");
            generator.write(this.reserved);
        }
        generator.writeKey("reserved_in_bytes");
        generator.write(this.reservedInBytes);
        if (this.totalDataSetSize != null) {
            generator.writeKey("total_data_set_size");
            generator.write(this.totalDataSetSize);
        }
        if (this.totalDataSetSizeInBytes != null) {
            generator.writeKey("total_data_set_size_in_bytes");
            generator.write(this.totalDataSetSizeInBytes.intValue());
        }
    }

    protected static void setupStoreStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size", new String[0]);
        op.add(Builder::sizeInBytes, JsonpDeserializer.integerDeserializer(), "size_in_bytes", new String[0]);
        op.add(Builder::reserved, JsonpDeserializer.stringDeserializer(), "reserved", new String[0]);
        op.add(Builder::reservedInBytes, JsonpDeserializer.integerDeserializer(), "reserved_in_bytes", new String[0]);
        op.add(Builder::totalDataSetSize, JsonpDeserializer.stringDeserializer(), "total_data_set_size", new String[0]);
        op.add(Builder::totalDataSetSizeInBytes, JsonpDeserializer.integerDeserializer(), "total_data_set_size_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<StoreStats> {
        @Nullable
        private String size;
        private Integer sizeInBytes;
        @Nullable
        private String reserved;
        private Integer reservedInBytes;
        @Nullable
        private String totalDataSetSize;
        @Nullable
        private Integer totalDataSetSizeInBytes;

        public Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        public Builder sizeInBytes(int value) {
            this.sizeInBytes = value;
            return this;
        }

        public Builder reserved(@Nullable String value) {
            this.reserved = value;
            return this;
        }

        public Builder reservedInBytes(int value) {
            this.reservedInBytes = value;
            return this;
        }

        public Builder totalDataSetSize(@Nullable String value) {
            this.totalDataSetSize = value;
            return this;
        }

        public Builder totalDataSetSizeInBytes(@Nullable Integer value) {
            this.totalDataSetSizeInBytes = value;
            return this;
        }

        @Override
        public StoreStats build() {
            return new StoreStats(this);
        }
    }
}

