/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ScriptBase
implements JsonpSerializable {
    @Nullable
    private final ScriptLanguage lang;
    @Nullable
    private final Map<String, JsonData> params;

    public ScriptBase(AbstractBuilder<?> builder) {
        this.lang = ((AbstractBuilder)builder).lang;
        this.params = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).params);
    }

    @Nullable
    public ScriptLanguage lang() {
        return this.lang;
    }

    @Nullable
    public Map<String, JsonData> params() {
        return this.params;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.lang != null) {
            generator.writeKey("lang");
            this.lang.serialize(generator, mapper);
        }
        if (this.params != null) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupScriptBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::lang, ScriptLanguage._DESERIALIZER, "lang", new String[0]);
        op.add(AbstractBuilder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private ScriptLanguage lang;
        @Nullable
        private Map<String, JsonData> params;

        protected AbstractBuilder() {
        }

        public BuilderT lang(@Nullable ScriptLanguage value) {
            this.lang = value;
            return this.self();
        }

        public BuilderT params(@Nullable Map<String, JsonData> value) {
            this.params = value;
            return this.self();
        }

        public BuilderT putParams(String key, JsonData value) {
            if (this.params == null) {
                this.params = new HashMap<String, JsonData>();
            }
            this.params.put(key, value);
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

