/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RecoveryStats
implements JsonpSerializable {
    private final long currentAsSource;
    private final long currentAsTarget;
    @Nullable
    private final String throttleTime;
    private final long throttleTimeInMillis;
    public static final JsonpDeserializer<RecoveryStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryStats::setupRecoveryStatsDeserializer, Builder::build);

    public RecoveryStats(Builder builder) {
        this.currentAsSource = Objects.requireNonNull(builder.currentAsSource, "current_as_source");
        this.currentAsTarget = Objects.requireNonNull(builder.currentAsTarget, "current_as_target");
        this.throttleTime = builder.throttleTime;
        this.throttleTimeInMillis = Objects.requireNonNull(builder.throttleTimeInMillis, "throttle_time_in_millis");
    }

    public RecoveryStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long currentAsSource() {
        return this.currentAsSource;
    }

    public long currentAsTarget() {
        return this.currentAsTarget;
    }

    @Nullable
    public String throttleTime() {
        return this.throttleTime;
    }

    public long throttleTimeInMillis() {
        return this.throttleTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current_as_source");
        generator.write(this.currentAsSource);
        generator.writeKey("current_as_target");
        generator.write(this.currentAsTarget);
        if (this.throttleTime != null) {
            generator.writeKey("throttle_time");
            generator.write(this.throttleTime);
        }
        generator.writeKey("throttle_time_in_millis");
        generator.write(this.throttleTimeInMillis);
    }

    protected static void setupRecoveryStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::currentAsSource, JsonpDeserializer.longDeserializer(), "current_as_source", new String[0]);
        op.add(Builder::currentAsTarget, JsonpDeserializer.longDeserializer(), "current_as_target", new String[0]);
        op.add(Builder::throttleTime, JsonpDeserializer.stringDeserializer(), "throttle_time", new String[0]);
        op.add(Builder::throttleTimeInMillis, JsonpDeserializer.longDeserializer(), "throttle_time_in_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RecoveryStats> {
        private Long currentAsSource;
        private Long currentAsTarget;
        @Nullable
        private String throttleTime;
        private Long throttleTimeInMillis;

        public Builder currentAsSource(long value) {
            this.currentAsSource = value;
            return this;
        }

        public Builder currentAsTarget(long value) {
            this.currentAsTarget = value;
            return this;
        }

        public Builder throttleTime(@Nullable String value) {
            this.throttleTime = value;
            return this;
        }

        public Builder throttleTimeInMillis(long value) {
            this.throttleTimeInMillis = value;
            return this;
        }

        @Override
        public RecoveryStats build() {
            return new RecoveryStats(this);
        }
    }
}

