/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetStats
implements JsonpSerializable {
    private final long current;
    @Nullable
    private final String existsTime;
    private final long existsTimeInMillis;
    private final long existsTotal;
    @Nullable
    private final String missingTime;
    private final long missingTimeInMillis;
    private final long missingTotal;
    @Nullable
    private final String time;
    private final long timeInMillis;
    private final long total;
    public static final JsonpDeserializer<GetStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetStats::setupGetStatsDeserializer, Builder::build);

    public GetStats(Builder builder) {
        this.current = Objects.requireNonNull(builder.current, "current");
        this.existsTime = builder.existsTime;
        this.existsTimeInMillis = Objects.requireNonNull(builder.existsTimeInMillis, "exists_time_in_millis");
        this.existsTotal = Objects.requireNonNull(builder.existsTotal, "exists_total");
        this.missingTime = builder.missingTime;
        this.missingTimeInMillis = Objects.requireNonNull(builder.missingTimeInMillis, "missing_time_in_millis");
        this.missingTotal = Objects.requireNonNull(builder.missingTotal, "missing_total");
        this.time = builder.time;
        this.timeInMillis = Objects.requireNonNull(builder.timeInMillis, "time_in_millis");
        this.total = Objects.requireNonNull(builder.total, "total");
    }

    public GetStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long current() {
        return this.current;
    }

    @Nullable
    public String existsTime() {
        return this.existsTime;
    }

    public long existsTimeInMillis() {
        return this.existsTimeInMillis;
    }

    public long existsTotal() {
        return this.existsTotal;
    }

    @Nullable
    public String missingTime() {
        return this.missingTime;
    }

    public long missingTimeInMillis() {
        return this.missingTimeInMillis;
    }

    public long missingTotal() {
        return this.missingTotal;
    }

    @Nullable
    public String time() {
        return this.time;
    }

    public long timeInMillis() {
        return this.timeInMillis;
    }

    public long total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current");
        generator.write(this.current);
        if (this.existsTime != null) {
            generator.writeKey("exists_time");
            generator.write(this.existsTime);
        }
        generator.writeKey("exists_time_in_millis");
        generator.write(this.existsTimeInMillis);
        generator.writeKey("exists_total");
        generator.write(this.existsTotal);
        if (this.missingTime != null) {
            generator.writeKey("missing_time");
            generator.write(this.missingTime);
        }
        generator.writeKey("missing_time_in_millis");
        generator.write(this.missingTimeInMillis);
        generator.writeKey("missing_total");
        generator.write(this.missingTotal);
        if (this.time != null) {
            generator.writeKey("time");
            generator.write(this.time);
        }
        generator.writeKey("time_in_millis");
        generator.write(this.timeInMillis);
        generator.writeKey("total");
        generator.write(this.total);
    }

    protected static void setupGetStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current", new String[0]);
        op.add(Builder::existsTime, JsonpDeserializer.stringDeserializer(), "exists_time", new String[0]);
        op.add(Builder::existsTimeInMillis, JsonpDeserializer.longDeserializer(), "exists_time_in_millis", new String[0]);
        op.add(Builder::existsTotal, JsonpDeserializer.longDeserializer(), "exists_total", new String[0]);
        op.add(Builder::missingTime, JsonpDeserializer.stringDeserializer(), "missing_time", new String[0]);
        op.add(Builder::missingTimeInMillis, JsonpDeserializer.longDeserializer(), "missing_time_in_millis", new String[0]);
        op.add(Builder::missingTotal, JsonpDeserializer.longDeserializer(), "missing_total", new String[0]);
        op.add(Builder::time, JsonpDeserializer.stringDeserializer(), "time", new String[0]);
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis", new String[0]);
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetStats> {
        private Long current;
        @Nullable
        private String existsTime;
        private Long existsTimeInMillis;
        private Long existsTotal;
        @Nullable
        private String missingTime;
        private Long missingTimeInMillis;
        private Long missingTotal;
        @Nullable
        private String time;
        private Long timeInMillis;
        private Long total;

        public Builder current(long value) {
            this.current = value;
            return this;
        }

        public Builder existsTime(@Nullable String value) {
            this.existsTime = value;
            return this;
        }

        public Builder existsTimeInMillis(long value) {
            this.existsTimeInMillis = value;
            return this;
        }

        public Builder existsTotal(long value) {
            this.existsTotal = value;
            return this;
        }

        public Builder missingTime(@Nullable String value) {
            this.missingTime = value;
            return this;
        }

        public Builder missingTimeInMillis(long value) {
            this.missingTimeInMillis = value;
            return this;
        }

        public Builder missingTotal(long value) {
            this.missingTotal = value;
            return this;
        }

        public Builder time(@Nullable String value) {
            this.time = value;
            return this;
        }

        public Builder timeInMillis(long value) {
            this.timeInMillis = value;
            return this;
        }

        public Builder total(long value) {
            this.total = value;
            return this;
        }

        @Override
        public GetStats build() {
            return new GetStats(this);
        }
    }
}

