/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.util;

import java.util.function.Function;

public interface ObjectBuilder<T> {
    public T build();

    public static <T> ObjectBuilder<T> constant(final T value) {
        return new ObjectBuilder<T>(){

            @Override
            public T build() {
                return value;
            }
        };
    }

    public static <B, U> ObjectBuilder<U> of(B builder, Function<B, U> buildFn) {
        return () -> buildFn.apply(builder);
    }
}

