/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class ValueBodyDeserializer<ObjectType>
extends DelegatingDeserializer<ObjectType> {
    private static final EnumSet<JsonParser.Event> allStartEvents = EnumSet.of(JsonParser.Event.START_OBJECT, new JsonParser.Event[]{JsonParser.Event.START_ARRAY, JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_NULL});
    private final Supplier<ObjectType> constructor;
    private BiConsumer<ObjectType, Object> setter;
    private JsonpDeserializer<?> valueDeserializer;

    public ValueBodyDeserializer(Supplier<ObjectType> constructor) {
        super(allStartEvents);
        this.constructor = constructor;
    }

    @Override
    public ObjectType deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
        ObjectType object = this.constructor.get();
        Object value = this.valueDeserializer.deserialize(parser, mapper, event);
        this.setter.accept(object, value);
        return object;
    }

    @Override
    public <FieldType> void add(BiConsumer<ObjectType, FieldType> setter, JsonpDeserializer<FieldType> valueParser, String name, String ... deprecatedNames) {
        BiConsumer<ObjectType, FieldType> tempSetter = setter;
        this.setter = tempSetter;
        this.valueDeserializer = valueParser;
    }

    @Override
    public void setKey(BiConsumer<ObjectType, String> setter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTypeProperty(String name) {
        throw new UnsupportedOperationException();
    }
}

