/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.WatcherActionTotals;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class WatcherActions
implements JsonpSerializable {
    private final Map<String, WatcherActionTotals> actions;
    public static final JsonpDeserializer<WatcherActions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatcherActions::setupWatcherActionsDeserializer, Builder::build);

    public WatcherActions(Builder builder) {
        this.actions = ModelTypeHelper.unmodifiableNonNull(builder.actions, "actions");
    }

    public WatcherActions(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, WatcherActionTotals> actions() {
        return this.actions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actions");
        generator.writeStartObject();
        for (Map.Entry<String, WatcherActionTotals> item0 : this.actions.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupWatcherActionsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.stringMapDeserializer(WatcherActionTotals._DESERIALIZER), "actions", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<WatcherActions> {
        private Map<String, WatcherActionTotals> actions;

        public Builder actions(Map<String, WatcherActionTotals> value) {
            this.actions = value;
            return this;
        }

        public Builder putActions(String key, WatcherActionTotals value) {
            if (this.actions == null) {
                this.actions = new HashMap<String, WatcherActionTotals>();
            }
            this.actions.put(key, value);
            return this;
        }

        public Builder actions(String key, Function<WatcherActionTotals.Builder, ObjectBuilder<WatcherActionTotals>> fn) {
            return this.actions(Collections.singletonMap(key, fn.apply(new WatcherActionTotals.Builder()).build()));
        }

        public Builder putActions(String key, Function<WatcherActionTotals.Builder, ObjectBuilder<WatcherActionTotals>> fn) {
            return this.putActions(key, fn.apply(new WatcherActionTotals.Builder()).build());
        }

        @Override
        public WatcherActions build() {
            return new WatcherActions(this);
        }
    }
}

