/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.MlInferenceIngestProcessor;
import co.elastic.clients.elasticsearch.xpack.usage.MlInferenceTrainedModels;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class MlInference
implements JsonpSerializable {
    private final Map<String, MlInferenceIngestProcessor> ingestProcessors;
    private final MlInferenceTrainedModels trainedModels;
    public static final JsonpDeserializer<MlInference> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MlInference::setupMlInferenceDeserializer, Builder::build);

    public MlInference(Builder builder) {
        this.ingestProcessors = ModelTypeHelper.unmodifiableNonNull(builder.ingestProcessors, "ingest_processors");
        this.trainedModels = Objects.requireNonNull(builder.trainedModels, "trained_models");
    }

    public MlInference(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, MlInferenceIngestProcessor> ingestProcessors() {
        return this.ingestProcessors;
    }

    public MlInferenceTrainedModels trainedModels() {
        return this.trainedModels;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("ingest_processors");
        generator.writeStartObject();
        for (Map.Entry<String, MlInferenceIngestProcessor> item0 : this.ingestProcessors.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("trained_models");
        this.trainedModels.serialize(generator, mapper);
    }

    protected static void setupMlInferenceDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::ingestProcessors, JsonpDeserializer.stringMapDeserializer(MlInferenceIngestProcessor._DESERIALIZER), "ingest_processors", new String[0]);
        op.add(Builder::trainedModels, MlInferenceTrainedModels._DESERIALIZER, "trained_models", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<MlInference> {
        private Map<String, MlInferenceIngestProcessor> ingestProcessors;
        private MlInferenceTrainedModels trainedModels;

        public Builder ingestProcessors(Map<String, MlInferenceIngestProcessor> value) {
            this.ingestProcessors = value;
            return this;
        }

        public Builder putIngestProcessors(String key, MlInferenceIngestProcessor value) {
            if (this.ingestProcessors == null) {
                this.ingestProcessors = new HashMap<String, MlInferenceIngestProcessor>();
            }
            this.ingestProcessors.put(key, value);
            return this;
        }

        public Builder ingestProcessors(String key, Function<MlInferenceIngestProcessor.Builder, ObjectBuilder<MlInferenceIngestProcessor>> fn) {
            return this.ingestProcessors(Collections.singletonMap(key, fn.apply(new MlInferenceIngestProcessor.Builder()).build()));
        }

        public Builder putIngestProcessors(String key, Function<MlInferenceIngestProcessor.Builder, ObjectBuilder<MlInferenceIngestProcessor>> fn) {
            return this.putIngestProcessors(key, fn.apply(new MlInferenceIngestProcessor.Builder()).build());
        }

        public Builder trainedModels(MlInferenceTrainedModels value) {
            this.trainedModels = value;
            return this;
        }

        public Builder trainedModels(Function<MlInferenceTrainedModels.Builder, ObjectBuilder<MlInferenceTrainedModels>> fn) {
            return this.trainedModels(fn.apply(new MlInferenceTrainedModels.Builder()).build());
        }

        @Override
        public MlInference build() {
            return new MlInference(this);
        }
    }
}

