/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DataStreams
extends Base {
    private final long dataStreams;
    private final long indicesCount;
    public static final JsonpDeserializer<DataStreams> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreams::setupDataStreamsDeserializer, Builder::build);

    public DataStreams(Builder builder) {
        super(builder);
        this.dataStreams = Objects.requireNonNull(builder.dataStreams, "data_streams");
        this.indicesCount = Objects.requireNonNull(builder.indicesCount, "indices_count");
    }

    public DataStreams(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long dataStreams() {
        return this.dataStreams;
    }

    public long indicesCount() {
        return this.indicesCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("data_streams");
        generator.write(this.dataStreams);
        generator.writeKey("indices_count");
        generator.write(this.indicesCount);
    }

    protected static void setupDataStreamsDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::dataStreams, JsonpDeserializer.longDeserializer(), "data_streams", new String[0]);
        op.add(Builder::indicesCount, JsonpDeserializer.longDeserializer(), "indices_count", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<DataStreams> {
        private Long dataStreams;
        private Long indicesCount;

        public Builder dataStreams(long value) {
            this.dataStreams = value;
            return this;
        }

        public Builder indicesCount(long value) {
            this.indicesCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreams build() {
            return new DataStreams(this);
        }
    }
}

