/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class HttpInputResponseResult
implements JsonpSerializable {
    private final String body;
    private final Map<String, List<String>> headers;
    private final int status;
    public static final JsonpDeserializer<HttpInputResponseResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HttpInputResponseResult::setupHttpInputResponseResultDeserializer, Builder::build);

    public HttpInputResponseResult(Builder builder) {
        this.body = Objects.requireNonNull(builder.body, "body");
        this.headers = ModelTypeHelper.unmodifiableNonNull(builder.headers, "headers");
        this.status = Objects.requireNonNull(builder.status, "status");
    }

    public HttpInputResponseResult(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String body() {
        return this.body;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public int status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("body");
        generator.write(this.body);
        generator.writeKey("headers");
        generator.writeStartObject();
        for (Map.Entry<String, List<String>> item0 : this.headers.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.writeStartArray();
            for (String item1 : item0.getValue()) {
                generator.write(item1);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
        generator.writeKey("status");
        generator.write(this.status);
    }

    protected static void setupHttpInputResponseResultDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::body, JsonpDeserializer.stringDeserializer(), "body", new String[0]);
        op.add(Builder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "headers", new String[0]);
        op.add(Builder::status, JsonpDeserializer.integerDeserializer(), "status", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<HttpInputResponseResult> {
        private String body;
        private Map<String, List<String>> headers;
        private Integer status;

        public Builder body(String value) {
            this.body = value;
            return this;
        }

        public Builder headers(Map<String, List<String>> value) {
            this.headers = value;
            return this;
        }

        public Builder putHeaders(String key, List<String> value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, List<String>>();
            }
            this.headers.put(key, value);
            return this;
        }

        public Builder status(int value) {
            this.status = value;
            return this;
        }

        @Override
        public HttpInputResponseResult build() {
            return new HttpInputResponseResult(this);
        }
    }
}

