/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.watcher.AckWatchResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class AckWatchRequest
extends RequestBase {
    private final String watchId;
    @Nullable
    private final List<String> actionId;
    public static final Endpoint<AckWatchRequest, AckWatchResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<AckWatchRequest, AckWatchResponse>(request -> "PUT", request -> {
        boolean _watchId = true;
        int _actionId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.actionId() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/watch");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.watchId, buf);
            buf.append("/_ack");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/watch");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.watchId, buf);
            buf.append("/_ack");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.actionId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, AckWatchResponse._DESERIALIZER);

    public AckWatchRequest(Builder builder) {
        this.watchId = Objects.requireNonNull(builder.watchId, "watch_id");
        this.actionId = ModelTypeHelper.unmodifiable(builder.actionId);
    }

    public AckWatchRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String watchId() {
        return this.watchId;
    }

    @Nullable
    public List<String> actionId() {
        return this.actionId;
    }

    public static class Builder
    implements ObjectBuilder<AckWatchRequest> {
        private String watchId;
        @Nullable
        private List<String> actionId;

        public Builder watchId(String value) {
            this.watchId = value;
            return this;
        }

        public Builder actionId(@Nullable List<String> value) {
            this.actionId = value;
            return this;
        }

        public Builder actionId(String ... value) {
            this.actionId = Arrays.asList(value);
            return this;
        }

        public Builder addActionId(String value) {
            if (this.actionId == null) {
                this.actionId = new ArrayList<String>();
            }
            this.actionId.add(value);
            return this;
        }

        @Override
        public AckWatchRequest build() {
            return new AckWatchRequest(this);
        }
    }
}

