/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch.transform.SyncVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TimeSync
implements SyncVariant,
JsonpSerializable {
    @Nullable
    private final String delay;
    private final String field;
    public static final JsonpDeserializer<TimeSync> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TimeSync::setupTimeSyncDeserializer, Builder::build);

    public TimeSync(Builder builder) {
        this.delay = builder.delay;
        this.field = Objects.requireNonNull(builder.field, "field");
    }

    public TimeSync(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "time";
    }

    @Nullable
    public String delay() {
        return this.delay;
    }

    public String field() {
        return this.field;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.delay != null) {
            generator.writeKey("delay");
            generator.write(this.delay);
        }
        generator.writeKey("field");
        generator.write(this.field);
    }

    protected static void setupTimeSyncDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::delay, JsonpDeserializer.stringDeserializer(), "delay", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TimeSync> {
        @Nullable
        private String delay;
        private String field;

        public Builder delay(@Nullable String value) {
            this.delay = value;
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        @Override
        public TimeSync build() {
            return new TimeSync(this);
        }
    }
}

