/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.text_structure;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.ingest.PipelineConfig;
import co.elastic.clients.elasticsearch.text_structure.find_structure.FieldStat;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FindStructureResponse
implements JsonpSerializable {
    private final String charset;
    @Nullable
    private final Boolean hasHeaderRow;
    private final boolean hasByteOrderMarker;
    private final String format;
    private final Map<String, FieldStat> fieldStats;
    private final String sampleStart;
    private final int numMessagesAnalyzed;
    private final TypeMapping mappings;
    @Nullable
    private final String quote;
    @Nullable
    private final String delimiter;
    private final boolean needClientTimezone;
    private final int numLinesAnalyzed;
    @Nullable
    private final List<String> columnNames;
    @Nullable
    private final List<String> explanation;
    @Nullable
    private final String grokPattern;
    @Nullable
    private final String multilineStartPattern;
    @Nullable
    private final String excludeLinesPattern;
    @Nullable
    private final List<String> javaTimestampFormats;
    @Nullable
    private final List<String> jodaTimestampFormats;
    @Nullable
    private final String timestampField;
    @Nullable
    private final Boolean shouldTrimFields;
    private final PipelineConfig ingestPipeline;
    public static final JsonpDeserializer<FindStructureResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FindStructureResponse::setupFindStructureResponseDeserializer, Builder::build);

    public FindStructureResponse(Builder builder) {
        this.charset = Objects.requireNonNull(builder.charset, "charset");
        this.hasHeaderRow = builder.hasHeaderRow;
        this.hasByteOrderMarker = Objects.requireNonNull(builder.hasByteOrderMarker, "has_byte_order_marker");
        this.format = Objects.requireNonNull(builder.format, "format");
        this.fieldStats = ModelTypeHelper.unmodifiableNonNull(builder.fieldStats, "field_stats");
        this.sampleStart = Objects.requireNonNull(builder.sampleStart, "sample_start");
        this.numMessagesAnalyzed = Objects.requireNonNull(builder.numMessagesAnalyzed, "num_messages_analyzed");
        this.mappings = Objects.requireNonNull(builder.mappings, "mappings");
        this.quote = builder.quote;
        this.delimiter = builder.delimiter;
        this.needClientTimezone = Objects.requireNonNull(builder.needClientTimezone, "need_client_timezone");
        this.numLinesAnalyzed = Objects.requireNonNull(builder.numLinesAnalyzed, "num_lines_analyzed");
        this.columnNames = ModelTypeHelper.unmodifiable(builder.columnNames);
        this.explanation = ModelTypeHelper.unmodifiable(builder.explanation);
        this.grokPattern = builder.grokPattern;
        this.multilineStartPattern = builder.multilineStartPattern;
        this.excludeLinesPattern = builder.excludeLinesPattern;
        this.javaTimestampFormats = ModelTypeHelper.unmodifiable(builder.javaTimestampFormats);
        this.jodaTimestampFormats = ModelTypeHelper.unmodifiable(builder.jodaTimestampFormats);
        this.timestampField = builder.timestampField;
        this.shouldTrimFields = builder.shouldTrimFields;
        this.ingestPipeline = Objects.requireNonNull(builder.ingestPipeline, "ingest_pipeline");
    }

    public FindStructureResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String charset() {
        return this.charset;
    }

    @Nullable
    public Boolean hasHeaderRow() {
        return this.hasHeaderRow;
    }

    public boolean hasByteOrderMarker() {
        return this.hasByteOrderMarker;
    }

    public String format() {
        return this.format;
    }

    public Map<String, FieldStat> fieldStats() {
        return this.fieldStats;
    }

    public String sampleStart() {
        return this.sampleStart;
    }

    public int numMessagesAnalyzed() {
        return this.numMessagesAnalyzed;
    }

    public TypeMapping mappings() {
        return this.mappings;
    }

    @Nullable
    public String quote() {
        return this.quote;
    }

    @Nullable
    public String delimiter() {
        return this.delimiter;
    }

    public boolean needClientTimezone() {
        return this.needClientTimezone;
    }

    public int numLinesAnalyzed() {
        return this.numLinesAnalyzed;
    }

    @Nullable
    public List<String> columnNames() {
        return this.columnNames;
    }

    @Nullable
    public List<String> explanation() {
        return this.explanation;
    }

    @Nullable
    public String grokPattern() {
        return this.grokPattern;
    }

    @Nullable
    public String multilineStartPattern() {
        return this.multilineStartPattern;
    }

    @Nullable
    public String excludeLinesPattern() {
        return this.excludeLinesPattern;
    }

    @Nullable
    public List<String> javaTimestampFormats() {
        return this.javaTimestampFormats;
    }

    @Nullable
    public List<String> jodaTimestampFormats() {
        return this.jodaTimestampFormats;
    }

    @Nullable
    public String timestampField() {
        return this.timestampField;
    }

    @Nullable
    public Boolean shouldTrimFields() {
        return this.shouldTrimFields;
    }

    public PipelineConfig ingestPipeline() {
        return this.ingestPipeline;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("charset");
        generator.write(this.charset);
        if (this.hasHeaderRow != null) {
            generator.writeKey("has_header_row");
            generator.write(this.hasHeaderRow.booleanValue());
        }
        generator.writeKey("has_byte_order_marker");
        generator.write(this.hasByteOrderMarker);
        generator.writeKey("format");
        generator.write(this.format);
        generator.writeKey("field_stats");
        generator.writeStartObject();
        for (Map.Entry<String, FieldStat> entry : this.fieldStats.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("sample_start");
        generator.write(this.sampleStart);
        generator.writeKey("num_messages_analyzed");
        generator.write(this.numMessagesAnalyzed);
        generator.writeKey("mappings");
        this.mappings.serialize(generator, mapper);
        if (this.quote != null) {
            generator.writeKey("quote");
            generator.write(this.quote);
        }
        if (this.delimiter != null) {
            generator.writeKey("delimiter");
            generator.write(this.delimiter);
        }
        generator.writeKey("need_client_timezone");
        generator.write(this.needClientTimezone);
        generator.writeKey("num_lines_analyzed");
        generator.write(this.numLinesAnalyzed);
        if (this.columnNames != null) {
            generator.writeKey("column_names");
            generator.writeStartArray();
            for (String string : this.columnNames) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.explanation != null) {
            generator.writeKey("explanation");
            generator.writeStartArray();
            for (String string : this.explanation) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.grokPattern != null) {
            generator.writeKey("grok_pattern");
            generator.write(this.grokPattern);
        }
        if (this.multilineStartPattern != null) {
            generator.writeKey("multiline_start_pattern");
            generator.write(this.multilineStartPattern);
        }
        if (this.excludeLinesPattern != null) {
            generator.writeKey("exclude_lines_pattern");
            generator.write(this.excludeLinesPattern);
        }
        if (this.javaTimestampFormats != null) {
            generator.writeKey("java_timestamp_formats");
            generator.writeStartArray();
            for (String string : this.javaTimestampFormats) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.jodaTimestampFormats != null) {
            generator.writeKey("joda_timestamp_formats");
            generator.writeStartArray();
            for (String string : this.jodaTimestampFormats) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.timestampField != null) {
            generator.writeKey("timestamp_field");
            generator.write(this.timestampField);
        }
        if (this.shouldTrimFields != null) {
            generator.writeKey("should_trim_fields");
            generator.write(this.shouldTrimFields.booleanValue());
        }
        generator.writeKey("ingest_pipeline");
        this.ingestPipeline.serialize(generator, mapper);
    }

    protected static void setupFindStructureResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::charset, JsonpDeserializer.stringDeserializer(), "charset", new String[0]);
        op.add(Builder::hasHeaderRow, JsonpDeserializer.booleanDeserializer(), "has_header_row", new String[0]);
        op.add(Builder::hasByteOrderMarker, JsonpDeserializer.booleanDeserializer(), "has_byte_order_marker", new String[0]);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format", new String[0]);
        op.add(Builder::fieldStats, JsonpDeserializer.stringMapDeserializer(FieldStat._DESERIALIZER), "field_stats", new String[0]);
        op.add(Builder::sampleStart, JsonpDeserializer.stringDeserializer(), "sample_start", new String[0]);
        op.add(Builder::numMessagesAnalyzed, JsonpDeserializer.integerDeserializer(), "num_messages_analyzed", new String[0]);
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings", new String[0]);
        op.add(Builder::quote, JsonpDeserializer.stringDeserializer(), "quote", new String[0]);
        op.add(Builder::delimiter, JsonpDeserializer.stringDeserializer(), "delimiter", new String[0]);
        op.add(Builder::needClientTimezone, JsonpDeserializer.booleanDeserializer(), "need_client_timezone", new String[0]);
        op.add(Builder::numLinesAnalyzed, JsonpDeserializer.integerDeserializer(), "num_lines_analyzed", new String[0]);
        op.add(Builder::columnNames, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "column_names", new String[0]);
        op.add(Builder::explanation, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "explanation", new String[0]);
        op.add(Builder::grokPattern, JsonpDeserializer.stringDeserializer(), "grok_pattern", new String[0]);
        op.add(Builder::multilineStartPattern, JsonpDeserializer.stringDeserializer(), "multiline_start_pattern", new String[0]);
        op.add(Builder::excludeLinesPattern, JsonpDeserializer.stringDeserializer(), "exclude_lines_pattern", new String[0]);
        op.add(Builder::javaTimestampFormats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "java_timestamp_formats", new String[0]);
        op.add(Builder::jodaTimestampFormats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "joda_timestamp_formats", new String[0]);
        op.add(Builder::timestampField, JsonpDeserializer.stringDeserializer(), "timestamp_field", new String[0]);
        op.add(Builder::shouldTrimFields, JsonpDeserializer.booleanDeserializer(), "should_trim_fields", new String[0]);
        op.add(Builder::ingestPipeline, PipelineConfig._DESERIALIZER, "ingest_pipeline", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FindStructureResponse> {
        private String charset;
        @Nullable
        private Boolean hasHeaderRow;
        private Boolean hasByteOrderMarker;
        private String format;
        private Map<String, FieldStat> fieldStats;
        private String sampleStart;
        private Integer numMessagesAnalyzed;
        private TypeMapping mappings;
        @Nullable
        private String quote;
        @Nullable
        private String delimiter;
        private Boolean needClientTimezone;
        private Integer numLinesAnalyzed;
        @Nullable
        private List<String> columnNames;
        @Nullable
        private List<String> explanation;
        @Nullable
        private String grokPattern;
        @Nullable
        private String multilineStartPattern;
        @Nullable
        private String excludeLinesPattern;
        @Nullable
        private List<String> javaTimestampFormats;
        @Nullable
        private List<String> jodaTimestampFormats;
        @Nullable
        private String timestampField;
        @Nullable
        private Boolean shouldTrimFields;
        private PipelineConfig ingestPipeline;

        public Builder charset(String value) {
            this.charset = value;
            return this;
        }

        public Builder hasHeaderRow(@Nullable Boolean value) {
            this.hasHeaderRow = value;
            return this;
        }

        public Builder hasByteOrderMarker(boolean value) {
            this.hasByteOrderMarker = value;
            return this;
        }

        public Builder format(String value) {
            this.format = value;
            return this;
        }

        public Builder fieldStats(Map<String, FieldStat> value) {
            this.fieldStats = value;
            return this;
        }

        public Builder putFieldStats(String key, FieldStat value) {
            if (this.fieldStats == null) {
                this.fieldStats = new HashMap<String, FieldStat>();
            }
            this.fieldStats.put(key, value);
            return this;
        }

        public Builder fieldStats(String key, Function<FieldStat.Builder, ObjectBuilder<FieldStat>> fn) {
            return this.fieldStats(Collections.singletonMap(key, fn.apply(new FieldStat.Builder()).build()));
        }

        public Builder putFieldStats(String key, Function<FieldStat.Builder, ObjectBuilder<FieldStat>> fn) {
            return this.putFieldStats(key, fn.apply(new FieldStat.Builder()).build());
        }

        public Builder sampleStart(String value) {
            this.sampleStart = value;
            return this;
        }

        public Builder numMessagesAnalyzed(int value) {
            this.numMessagesAnalyzed = value;
            return this;
        }

        public Builder mappings(TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        public Builder quote(@Nullable String value) {
            this.quote = value;
            return this;
        }

        public Builder delimiter(@Nullable String value) {
            this.delimiter = value;
            return this;
        }

        public Builder needClientTimezone(boolean value) {
            this.needClientTimezone = value;
            return this;
        }

        public Builder numLinesAnalyzed(int value) {
            this.numLinesAnalyzed = value;
            return this;
        }

        public Builder columnNames(@Nullable List<String> value) {
            this.columnNames = value;
            return this;
        }

        public Builder columnNames(String ... value) {
            this.columnNames = Arrays.asList(value);
            return this;
        }

        public Builder addColumnNames(String value) {
            if (this.columnNames == null) {
                this.columnNames = new ArrayList<String>();
            }
            this.columnNames.add(value);
            return this;
        }

        public Builder explanation(@Nullable List<String> value) {
            this.explanation = value;
            return this;
        }

        public Builder explanation(String ... value) {
            this.explanation = Arrays.asList(value);
            return this;
        }

        public Builder addExplanation(String value) {
            if (this.explanation == null) {
                this.explanation = new ArrayList<String>();
            }
            this.explanation.add(value);
            return this;
        }

        public Builder grokPattern(@Nullable String value) {
            this.grokPattern = value;
            return this;
        }

        public Builder multilineStartPattern(@Nullable String value) {
            this.multilineStartPattern = value;
            return this;
        }

        public Builder excludeLinesPattern(@Nullable String value) {
            this.excludeLinesPattern = value;
            return this;
        }

        public Builder javaTimestampFormats(@Nullable List<String> value) {
            this.javaTimestampFormats = value;
            return this;
        }

        public Builder javaTimestampFormats(String ... value) {
            this.javaTimestampFormats = Arrays.asList(value);
            return this;
        }

        public Builder addJavaTimestampFormats(String value) {
            if (this.javaTimestampFormats == null) {
                this.javaTimestampFormats = new ArrayList<String>();
            }
            this.javaTimestampFormats.add(value);
            return this;
        }

        public Builder jodaTimestampFormats(@Nullable List<String> value) {
            this.jodaTimestampFormats = value;
            return this;
        }

        public Builder jodaTimestampFormats(String ... value) {
            this.jodaTimestampFormats = Arrays.asList(value);
            return this;
        }

        public Builder addJodaTimestampFormats(String value) {
            if (this.jodaTimestampFormats == null) {
                this.jodaTimestampFormats = new ArrayList<String>();
            }
            this.jodaTimestampFormats.add(value);
            return this;
        }

        public Builder timestampField(@Nullable String value) {
            this.timestampField = value;
            return this;
        }

        public Builder shouldTrimFields(@Nullable Boolean value) {
            this.shouldTrimFields = value;
            return this;
        }

        public Builder ingestPipeline(PipelineConfig value) {
            this.ingestPipeline = value;
            return this;
        }

        public Builder ingestPipeline(Function<PipelineConfig.Builder, ObjectBuilder<PipelineConfig>> fn) {
            return this.ingestPipeline(fn.apply(new PipelineConfig.Builder()).build());
        }

        @Override
        public FindStructureResponse build() {
            return new FindStructureResponse(this);
        }
    }
}

