/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RepositorySettings
implements JsonpSerializable {
    @Nullable
    private final String chunkSize;
    @Nullable
    private final Boolean compress;
    @Nullable
    private final String concurrentStreams;
    private final String location;
    @Nullable
    private final Boolean readOnly;
    public static final JsonpDeserializer<RepositorySettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RepositorySettings::setupRepositorySettingsDeserializer, Builder::build);

    public RepositorySettings(Builder builder) {
        this.chunkSize = builder.chunkSize;
        this.compress = builder.compress;
        this.concurrentStreams = builder.concurrentStreams;
        this.location = Objects.requireNonNull(builder.location, "location");
        this.readOnly = builder.readOnly;
    }

    public RepositorySettings(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String chunkSize() {
        return this.chunkSize;
    }

    @Nullable
    public Boolean compress() {
        return this.compress;
    }

    @Nullable
    public String concurrentStreams() {
        return this.concurrentStreams;
    }

    public String location() {
        return this.location;
    }

    @Nullable
    public Boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkSize != null) {
            generator.writeKey("chunk_size");
            generator.write(this.chunkSize);
        }
        if (this.compress != null) {
            generator.writeKey("compress");
            generator.write(this.compress.booleanValue());
        }
        if (this.concurrentStreams != null) {
            generator.writeKey("concurrent_streams");
            generator.write(this.concurrentStreams);
        }
        generator.writeKey("location");
        generator.write(this.location);
        if (this.readOnly != null) {
            generator.writeKey("read_only");
            generator.write(this.readOnly.booleanValue());
        }
    }

    protected static void setupRepositorySettingsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::chunkSize, JsonpDeserializer.stringDeserializer(), "chunk_size", new String[0]);
        op.add(Builder::compress, JsonpDeserializer.booleanDeserializer(), "compress", new String[0]);
        op.add(Builder::concurrentStreams, JsonpDeserializer.stringDeserializer(), "concurrent_streams", new String[0]);
        op.add(Builder::location, JsonpDeserializer.stringDeserializer(), "location", new String[0]);
        op.add(Builder::readOnly, JsonpDeserializer.booleanDeserializer(), "read_only", "readonly");
    }

    public static class Builder
    implements ObjectBuilder<RepositorySettings> {
        @Nullable
        private String chunkSize;
        @Nullable
        private Boolean compress;
        @Nullable
        private String concurrentStreams;
        private String location;
        @Nullable
        private Boolean readOnly;

        public Builder chunkSize(@Nullable String value) {
            this.chunkSize = value;
            return this;
        }

        public Builder compress(@Nullable Boolean value) {
            this.compress = value;
            return this;
        }

        public Builder concurrentStreams(@Nullable String value) {
            this.concurrentStreams = value;
            return this;
        }

        public Builder location(String value) {
            this.location = value;
            return this;
        }

        public Builder readOnly(@Nullable Boolean value) {
            this.readOnly = value;
            return this;
        }

        @Override
        public RepositorySettings build() {
            return new RepositorySettings(this);
        }
    }
}

