/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class InfoFeatureState
implements JsonpSerializable {
    private final String featureName;
    private final List<String> indices;
    public static final JsonpDeserializer<InfoFeatureState> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InfoFeatureState::setupInfoFeatureStateDeserializer, Builder::build);

    public InfoFeatureState(Builder builder) {
        this.featureName = Objects.requireNonNull(builder.featureName, "feature_name");
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
    }

    public InfoFeatureState(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String featureName() {
        return this.featureName;
    }

    public List<String> indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("feature_name");
        generator.write(this.featureName);
        generator.writeKey("indices");
        generator.writeStartArray();
        for (String item0 : this.indices) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupInfoFeatureStateDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::featureName, JsonpDeserializer.stringDeserializer(), "feature_name", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<InfoFeatureState> {
        private String featureName;
        private List<String> indices;

        public Builder featureName(String value) {
            this.featureName = value;
            return this;
        }

        public Builder indices(List<String> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(String ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(String value) {
            if (this.indices == null) {
                this.indices = new ArrayList<String>();
            }
            this.indices.add(value);
            return this;
        }

        @Override
        public InfoFeatureState build() {
            return new InfoFeatureState(this);
        }
    }
}

