/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.snapshot.GetResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class GetRequest
extends RequestBase {
    private final String repository;
    private final List<String> snapshot;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final Boolean verbose;
    @Nullable
    private final Boolean indexDetails;
    @Nullable
    private final Boolean human;
    @Nullable
    private final Boolean includeRepository;
    public static final Endpoint<GetRequest, GetResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetRequest, GetResponse>(request -> "GET", request -> {
        boolean _repository = true;
        int _snapshot = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshot.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.verbose != null) {
            params.put("verbose", String.valueOf(request.verbose));
        }
        if (request.indexDetails != null) {
            params.put("index_details", String.valueOf(request.indexDetails));
        }
        if (request.human != null) {
            params.put("human", String.valueOf(request.human));
        }
        if (request.includeRepository != null) {
            params.put("include_repository", String.valueOf(request.includeRepository));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetResponse._DESERIALIZER);

    public GetRequest(Builder builder) {
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.snapshot = ModelTypeHelper.unmodifiableNonNull(builder.snapshot, "snapshot");
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.masterTimeout = builder.masterTimeout;
        this.verbose = builder.verbose;
        this.indexDetails = builder.indexDetails;
        this.human = builder.human;
        this.includeRepository = builder.includeRepository;
    }

    public GetRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String repository() {
        return this.repository;
    }

    public List<String> snapshot() {
        return this.snapshot;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public Boolean verbose() {
        return this.verbose;
    }

    @Nullable
    public Boolean indexDetails() {
        return this.indexDetails;
    }

    @Nullable
    public Boolean human() {
        return this.human;
    }

    @Nullable
    public Boolean includeRepository() {
        return this.includeRepository;
    }

    public static class Builder
    implements ObjectBuilder<GetRequest> {
        private String repository;
        private List<String> snapshot;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private String masterTimeout;
        @Nullable
        private Boolean verbose;
        @Nullable
        private Boolean indexDetails;
        @Nullable
        private Boolean human;
        @Nullable
        private Boolean includeRepository;

        public Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public Builder snapshot(List<String> value) {
            this.snapshot = value;
            return this;
        }

        public Builder snapshot(String ... value) {
            this.snapshot = Arrays.asList(value);
            return this;
        }

        public Builder addSnapshot(String value) {
            if (this.snapshot == null) {
                this.snapshot = new ArrayList<String>();
            }
            this.snapshot.add(value);
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder verbose(@Nullable Boolean value) {
            this.verbose = value;
            return this;
        }

        public Builder indexDetails(@Nullable Boolean value) {
            this.indexDetails = value;
            return this;
        }

        public Builder human(@Nullable Boolean value) {
            this.human = value;
            return this;
        }

        public Builder includeRepository(@Nullable Boolean value) {
            this.includeRepository = value;
            return this;
        }

        @Override
        public GetRequest build() {
            return new GetRequest(this);
        }
    }
}

