/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.SnapshotInfo;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CreateResponse
implements JsonpSerializable {
    @Nullable
    private final Boolean accepted;
    private final SnapshotInfo snapshot;
    public static final JsonpDeserializer<CreateResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateResponse::setupCreateResponseDeserializer, Builder::build);

    public CreateResponse(Builder builder) {
        this.accepted = builder.accepted;
        this.snapshot = Objects.requireNonNull(builder.snapshot, "snapshot");
    }

    public CreateResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean accepted() {
        return this.accepted;
    }

    public SnapshotInfo snapshot() {
        return this.snapshot;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.accepted != null) {
            generator.writeKey("accepted");
            generator.write(this.accepted.booleanValue());
        }
        generator.writeKey("snapshot");
        this.snapshot.serialize(generator, mapper);
    }

    protected static void setupCreateResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::accepted, JsonpDeserializer.booleanDeserializer(), "accepted", new String[0]);
        op.add(Builder::snapshot, SnapshotInfo._DESERIALIZER, "snapshot", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CreateResponse> {
        @Nullable
        private Boolean accepted;
        private SnapshotInfo snapshot;

        public Builder accepted(@Nullable Boolean value) {
            this.accepted = value;
            return this;
        }

        public Builder snapshot(SnapshotInfo value) {
            this.snapshot = value;
            return this;
        }

        public Builder snapshot(Function<SnapshotInfo.Builder, ObjectBuilder<SnapshotInfo>> fn) {
            return this.snapshot(fn.apply(new SnapshotInfo.Builder()).build());
        }

        @Override
        public CreateResponse build() {
            return new CreateResponse(this);
        }
    }
}

