/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.shutdown;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.shutdown.PutNodeResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class PutNodeRequest
extends RequestBase {
    private final String nodeId;
    public static final Endpoint<PutNodeRequest, PutNodeResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutNodeRequest, PutNodeResponse>(request -> "PUT", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId, buf);
            buf.append("/shutdown");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, PutNodeResponse._DESERIALIZER);

    public PutNodeRequest(Builder builder) {
        this.nodeId = Objects.requireNonNull(builder.nodeId, "node_id");
    }

    public PutNodeRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String nodeId() {
        return this.nodeId;
    }

    public static class Builder
    implements ObjectBuilder<PutNodeRequest> {
        private String nodeId;

        public Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        @Override
        public PutNodeRequest build() {
            return new PutNodeRequest(this);
        }
    }
}

