/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class InvalidateTokenResponse
implements JsonpSerializable {
    private final long errorCount;
    @Nullable
    private final List<ErrorCause> errorDetails;
    private final long invalidatedTokens;
    private final long previouslyInvalidatedTokens;
    public static final JsonpDeserializer<InvalidateTokenResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InvalidateTokenResponse::setupInvalidateTokenResponseDeserializer, Builder::build);

    public InvalidateTokenResponse(Builder builder) {
        this.errorCount = Objects.requireNonNull(builder.errorCount, "error_count");
        this.errorDetails = ModelTypeHelper.unmodifiable(builder.errorDetails);
        this.invalidatedTokens = Objects.requireNonNull(builder.invalidatedTokens, "invalidated_tokens");
        this.previouslyInvalidatedTokens = Objects.requireNonNull(builder.previouslyInvalidatedTokens, "previously_invalidated_tokens");
    }

    public InvalidateTokenResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long errorCount() {
        return this.errorCount;
    }

    @Nullable
    public List<ErrorCause> errorDetails() {
        return this.errorDetails;
    }

    public long invalidatedTokens() {
        return this.invalidatedTokens;
    }

    public long previouslyInvalidatedTokens() {
        return this.previouslyInvalidatedTokens;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("error_count");
        generator.write(this.errorCount);
        if (this.errorDetails != null) {
            generator.writeKey("error_details");
            generator.writeStartArray();
            for (ErrorCause item0 : this.errorDetails) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("invalidated_tokens");
        generator.write(this.invalidatedTokens);
        generator.writeKey("previously_invalidated_tokens");
        generator.write(this.previouslyInvalidatedTokens);
    }

    protected static void setupInvalidateTokenResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::errorCount, JsonpDeserializer.longDeserializer(), "error_count", new String[0]);
        op.add(Builder::errorDetails, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "error_details", new String[0]);
        op.add(Builder::invalidatedTokens, JsonpDeserializer.longDeserializer(), "invalidated_tokens", new String[0]);
        op.add(Builder::previouslyInvalidatedTokens, JsonpDeserializer.longDeserializer(), "previously_invalidated_tokens", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<InvalidateTokenResponse> {
        private Long errorCount;
        @Nullable
        private List<ErrorCause> errorDetails;
        private Long invalidatedTokens;
        private Long previouslyInvalidatedTokens;

        public Builder errorCount(long value) {
            this.errorCount = value;
            return this;
        }

        public Builder errorDetails(@Nullable List<ErrorCause> value) {
            this.errorDetails = value;
            return this;
        }

        public Builder errorDetails(ErrorCause ... value) {
            this.errorDetails = Arrays.asList(value);
            return this;
        }

        public Builder addErrorDetails(ErrorCause value) {
            if (this.errorDetails == null) {
                this.errorDetails = new ArrayList<ErrorCause>();
            }
            this.errorDetails.add(value);
            return this;
        }

        public Builder errorDetails(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.errorDetails(fn.apply(new ErrorCause.Builder()).build());
        }

        public Builder addErrorDetails(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.addErrorDetails(fn.apply(new ErrorCause.Builder()).build());
        }

        public Builder invalidatedTokens(long value) {
            this.invalidatedTokens = value;
            return this;
        }

        public Builder previouslyInvalidatedTokens(long value) {
            this.previouslyInvalidatedTokens = value;
            return this;
        }

        @Override
        public InvalidateTokenResponse build() {
            return new InvalidateTokenResponse(this);
        }
    }
}

