/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.get_token.AuthenticatedUser;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetTokenResponse
implements JsonpSerializable {
    private final String accessToken;
    private final long expiresIn;
    @Nullable
    private final String scope;
    private final String type;
    private final String refreshToken;
    @Nullable
    private final String kerberosAuthenticationResponseToken;
    private final AuthenticatedUser authentication;
    public static final JsonpDeserializer<GetTokenResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetTokenResponse::setupGetTokenResponseDeserializer, Builder::build);

    public GetTokenResponse(Builder builder) {
        this.accessToken = Objects.requireNonNull(builder.accessToken, "access_token");
        this.expiresIn = Objects.requireNonNull(builder.expiresIn, "expires_in");
        this.scope = builder.scope;
        this.type = Objects.requireNonNull(builder.type, "type");
        this.refreshToken = Objects.requireNonNull(builder.refreshToken, "refresh_token");
        this.kerberosAuthenticationResponseToken = builder.kerberosAuthenticationResponseToken;
        this.authentication = Objects.requireNonNull(builder.authentication, "authentication");
    }

    public GetTokenResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String accessToken() {
        return this.accessToken;
    }

    public long expiresIn() {
        return this.expiresIn;
    }

    @Nullable
    public String scope() {
        return this.scope;
    }

    public String type() {
        return this.type;
    }

    public String refreshToken() {
        return this.refreshToken;
    }

    @Nullable
    public String kerberosAuthenticationResponseToken() {
        return this.kerberosAuthenticationResponseToken;
    }

    public AuthenticatedUser authentication() {
        return this.authentication;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("access_token");
        generator.write(this.accessToken);
        generator.writeKey("expires_in");
        generator.write(this.expiresIn);
        if (this.scope != null) {
            generator.writeKey("scope");
            generator.write(this.scope);
        }
        generator.writeKey("type");
        generator.write(this.type);
        generator.writeKey("refresh_token");
        generator.write(this.refreshToken);
        if (this.kerberosAuthenticationResponseToken != null) {
            generator.writeKey("kerberos_authentication_response_token");
            generator.write(this.kerberosAuthenticationResponseToken);
        }
        generator.writeKey("authentication");
        this.authentication.serialize(generator, mapper);
    }

    protected static void setupGetTokenResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::accessToken, JsonpDeserializer.stringDeserializer(), "access_token", new String[0]);
        op.add(Builder::expiresIn, JsonpDeserializer.longDeserializer(), "expires_in", new String[0]);
        op.add(Builder::scope, JsonpDeserializer.stringDeserializer(), "scope", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
        op.add(Builder::refreshToken, JsonpDeserializer.stringDeserializer(), "refresh_token", new String[0]);
        op.add(Builder::kerberosAuthenticationResponseToken, JsonpDeserializer.stringDeserializer(), "kerberos_authentication_response_token", new String[0]);
        op.add(Builder::authentication, AuthenticatedUser._DESERIALIZER, "authentication", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetTokenResponse> {
        private String accessToken;
        private Long expiresIn;
        @Nullable
        private String scope;
        private String type;
        private String refreshToken;
        @Nullable
        private String kerberosAuthenticationResponseToken;
        private AuthenticatedUser authentication;

        public Builder accessToken(String value) {
            this.accessToken = value;
            return this;
        }

        public Builder expiresIn(long value) {
            this.expiresIn = value;
            return this;
        }

        public Builder scope(@Nullable String value) {
            this.scope = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder refreshToken(String value) {
            this.refreshToken = value;
            return this;
        }

        public Builder kerberosAuthenticationResponseToken(@Nullable String value) {
            this.kerberosAuthenticationResponseToken = value;
            return this;
        }

        public Builder authentication(AuthenticatedUser value) {
            this.authentication = value;
            return this;
        }

        public Builder authentication(Function<AuthenticatedUser.Builder, ObjectBuilder<AuthenticatedUser>> fn) {
            return this.authentication(fn.apply(new AuthenticatedUser.Builder()).build());
        }

        @Override
        public GetTokenResponse build() {
            return new GetTokenResponse(this);
        }
    }
}

