/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.get_api_key.ApiKey;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class GetApiKeyResponse
implements JsonpSerializable {
    private final List<ApiKey> apiKeys;
    public static final JsonpDeserializer<GetApiKeyResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetApiKeyResponse::setupGetApiKeyResponseDeserializer, Builder::build);

    public GetApiKeyResponse(Builder builder) {
        this.apiKeys = ModelTypeHelper.unmodifiableNonNull(builder.apiKeys, "api_keys");
    }

    public GetApiKeyResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<ApiKey> apiKeys() {
        return this.apiKeys;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_keys");
        generator.writeStartArray();
        for (ApiKey item0 : this.apiKeys) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetApiKeyResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::apiKeys, JsonpDeserializer.arrayDeserializer(ApiKey._DESERIALIZER), "api_keys", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetApiKeyResponse> {
        private List<ApiKey> apiKeys;

        public Builder apiKeys(List<ApiKey> value) {
            this.apiKeys = value;
            return this;
        }

        public Builder apiKeys(ApiKey ... value) {
            this.apiKeys = Arrays.asList(value);
            return this;
        }

        public Builder addApiKeys(ApiKey value) {
            if (this.apiKeys == null) {
                this.apiKeys = new ArrayList<ApiKey>();
            }
            this.apiKeys.add(value);
            return this;
        }

        public Builder apiKeys(Function<ApiKey.Builder, ObjectBuilder<ApiKey>> fn) {
            return this.apiKeys(fn.apply(new ApiKey.Builder()).build());
        }

        public Builder addApiKeys(Function<ApiKey.Builder, ObjectBuilder<ApiKey>> fn) {
            return this.addApiKeys(fn.apply(new ApiKey.Builder()).build());
        }

        @Override
        public GetApiKeyResponse build() {
            return new GetApiKeyResponse(this);
        }
    }
}

