/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.DeleteRoleResponse;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeleteRoleRequest
extends RequestBase {
    private final String name;
    @Nullable
    private final JsonValue refresh;
    public static final Endpoint<DeleteRoleRequest, DeleteRoleResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteRoleRequest, DeleteRoleResponse>(request -> "DELETE", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/role");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteRoleResponse._DESERIALIZER);

    public DeleteRoleRequest(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.refresh = builder.refresh;
    }

    public DeleteRoleRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    public static class Builder
    implements ObjectBuilder<DeleteRoleRequest> {
        private String name;
        @Nullable
        private JsonValue refresh;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        @Override
        public DeleteRoleRequest build() {
            return new DeleteRoleRequest(this);
        }
    }
}

