/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CreateApiKeyResponse
implements JsonpSerializable {
    private final String apiKey;
    @Nullable
    private final Long expiration;
    private final String id;
    private final String name;
    public static final JsonpDeserializer<CreateApiKeyResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateApiKeyResponse::setupCreateApiKeyResponseDeserializer, Builder::build);

    public CreateApiKeyResponse(Builder builder) {
        this.apiKey = Objects.requireNonNull(builder.apiKey, "api_key");
        this.expiration = builder.expiration;
        this.id = Objects.requireNonNull(builder.id, "id");
        this.name = Objects.requireNonNull(builder.name, "name");
    }

    public CreateApiKeyResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String apiKey() {
        return this.apiKey;
    }

    @Nullable
    public Long expiration() {
        return this.expiration;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        generator.write(this.apiKey);
        if (this.expiration != null) {
            generator.writeKey("expiration");
            generator.write(this.expiration.longValue());
        }
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("name");
        generator.write(this.name);
    }

    protected static void setupCreateApiKeyResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key", new String[0]);
        op.add(Builder::expiration, JsonpDeserializer.longDeserializer(), "expiration", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CreateApiKeyResponse> {
        private String apiKey;
        @Nullable
        private Long expiration;
        private String id;
        private String name;

        public Builder apiKey(String value) {
            this.apiKey = value;
            return this;
        }

        public Builder expiration(@Nullable Long value) {
            this.expiration = value;
            return this;
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        public CreateApiKeyResponse build() {
            return new CreateApiKeyResponse(this);
        }
    }
}

