/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch.nodes.info.NodeInfoXpackLicense;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoXpackSecurity;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NodeInfoXpack
implements JsonpSerializable {
    @Nullable
    private final NodeInfoXpackLicense license;
    private final NodeInfoXpackSecurity security;
    @Nullable
    private final Map<String, JsonData> notification;
    public static final JsonpDeserializer<NodeInfoXpack> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoXpack::setupNodeInfoXpackDeserializer, Builder::build);

    public NodeInfoXpack(Builder builder) {
        this.license = builder.license;
        this.security = Objects.requireNonNull(builder.security, "security");
        this.notification = ModelTypeHelper.unmodifiable(builder.notification);
    }

    public NodeInfoXpack(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public NodeInfoXpackLicense license() {
        return this.license;
    }

    public NodeInfoXpackSecurity security() {
        return this.security;
    }

    @Nullable
    public Map<String, JsonData> notification() {
        return this.notification;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.license != null) {
            generator.writeKey("license");
            this.license.serialize(generator, mapper);
        }
        generator.writeKey("security");
        this.security.serialize(generator, mapper);
        if (this.notification != null) {
            generator.writeKey("notification");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.notification.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupNodeInfoXpackDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::license, NodeInfoXpackLicense._DESERIALIZER, "license", new String[0]);
        op.add(Builder::security, NodeInfoXpackSecurity._DESERIALIZER, "security", new String[0]);
        op.add(Builder::notification, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "notification", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfoXpack> {
        @Nullable
        private NodeInfoXpackLicense license;
        private NodeInfoXpackSecurity security;
        @Nullable
        private Map<String, JsonData> notification;

        public Builder license(@Nullable NodeInfoXpackLicense value) {
            this.license = value;
            return this;
        }

        public Builder license(Function<NodeInfoXpackLicense.Builder, ObjectBuilder<NodeInfoXpackLicense>> fn) {
            return this.license(fn.apply(new NodeInfoXpackLicense.Builder()).build());
        }

        public Builder security(NodeInfoXpackSecurity value) {
            this.security = value;
            return this;
        }

        public Builder security(Function<NodeInfoXpackSecurity.Builder, ObjectBuilder<NodeInfoXpackSecurity>> fn) {
            return this.security(fn.apply(new NodeInfoXpackSecurity.Builder()).build());
        }

        public Builder notification(@Nullable Map<String, JsonData> value) {
            this.notification = value;
            return this;
        }

        public Builder putNotification(String key, JsonData value) {
            if (this.notification == null) {
                this.notification = new HashMap<String, JsonData>();
            }
            this.notification.put(key, value);
            return this;
        }

        @Override
        public NodeInfoXpack build() {
            return new NodeInfoXpack(this);
        }
    }
}

