/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.nodes.ReloadSecureSettingsResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ReloadSecureSettingsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final List<String> nodeId;
    @Nullable
    private final String timeout;
    @Nullable
    private final String secureSettingsPassword;
    public static final JsonpDeserializer<ReloadSecureSettingsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReloadSecureSettingsRequest::setupReloadSecureSettingsRequestDeserializer, Builder::build);
    public static final Endpoint<ReloadSecureSettingsRequest, ReloadSecureSettingsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ReloadSecureSettingsRequest, ReloadSecureSettingsResponse>(request -> "POST", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (request.nodeId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/reload_secure_settings");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/reload_secure_settings");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, ReloadSecureSettingsResponse._DESERIALIZER);

    public ReloadSecureSettingsRequest(Builder builder) {
        this.nodeId = ModelTypeHelper.unmodifiable(builder.nodeId);
        this.timeout = builder.timeout;
        this.secureSettingsPassword = builder.secureSettingsPassword;
    }

    public ReloadSecureSettingsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public String secureSettingsPassword() {
        return this.secureSettingsPassword;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.secureSettingsPassword != null) {
            generator.writeKey("secure_settings_password");
            generator.write(this.secureSettingsPassword);
        }
    }

    protected static void setupReloadSecureSettingsRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::secureSettingsPassword, JsonpDeserializer.stringDeserializer(), "secure_settings_password", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ReloadSecureSettingsRequest> {
        @Nullable
        private List<String> nodeId;
        @Nullable
        private String timeout;
        @Nullable
        private String secureSettingsPassword;

        public Builder nodeId(@Nullable List<String> value) {
            this.nodeId = value;
            return this;
        }

        public Builder nodeId(String ... value) {
            this.nodeId = Arrays.asList(value);
            return this;
        }

        public Builder addNodeId(String value) {
            if (this.nodeId == null) {
                this.nodeId = new ArrayList<String>();
            }
            this.nodeId.add(value);
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder secureSettingsPassword(@Nullable String value) {
            this.secureSettingsPassword = value;
            return this;
        }

        @Override
        public ReloadSecureSettingsRequest build() {
            return new ReloadSecureSettingsRequest(this);
        }
    }
}

