/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.UpgradeJobSnapshotResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class UpgradeJobSnapshotRequest
extends RequestBase {
    private final String jobId;
    private final String snapshotId;
    @Nullable
    private final Boolean waitForCompletion;
    @Nullable
    private final String timeout;
    public static final Endpoint<UpgradeJobSnapshotRequest, UpgradeJobSnapshotResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<UpgradeJobSnapshotRequest, UpgradeJobSnapshotResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        int _snapshotId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/model_snapshots");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshotId, buf);
            buf.append("/_upgrade");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, UpgradeJobSnapshotResponse._DESERIALIZER);

    public UpgradeJobSnapshotRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.snapshotId = Objects.requireNonNull(builder.snapshotId, "snapshot_id");
        this.waitForCompletion = builder.waitForCompletion;
        this.timeout = builder.timeout;
    }

    public UpgradeJobSnapshotRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    @Nullable
    public Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<UpgradeJobSnapshotRequest> {
        private String jobId;
        private String snapshotId;
        @Nullable
        private Boolean waitForCompletion;
        @Nullable
        private String timeout;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder snapshotId(String value) {
            this.snapshotId = value;
            return this;
        }

        public Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public UpgradeJobSnapshotRequest build() {
            return new UpgradeJobSnapshotRequest(this);
        }
    }
}

