/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Hyperparameter
implements JsonpSerializable {
    @Nullable
    private final Double absoluteImportance;
    private final String name;
    @Nullable
    private final Double relativeImportance;
    private final boolean supplied;
    private final double value;
    public static final JsonpDeserializer<Hyperparameter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Hyperparameter::setupHyperparameterDeserializer, Builder::build);

    public Hyperparameter(Builder builder) {
        this.absoluteImportance = builder.absoluteImportance;
        this.name = Objects.requireNonNull(builder.name, "name");
        this.relativeImportance = builder.relativeImportance;
        this.supplied = Objects.requireNonNull(builder.supplied, "supplied");
        this.value = Objects.requireNonNull(builder.value, "value");
    }

    public Hyperparameter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Double absoluteImportance() {
        return this.absoluteImportance;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public Double relativeImportance() {
        return this.relativeImportance;
    }

    public boolean supplied() {
        return this.supplied;
    }

    public double value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.absoluteImportance != null) {
            generator.writeKey("absolute_importance");
            generator.write(this.absoluteImportance.doubleValue());
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (this.relativeImportance != null) {
            generator.writeKey("relative_importance");
            generator.write(this.relativeImportance.doubleValue());
        }
        generator.writeKey("supplied");
        generator.write(this.supplied);
        generator.writeKey("value");
        generator.write(this.value);
    }

    protected static void setupHyperparameterDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::absoluteImportance, JsonpDeserializer.doubleDeserializer(), "absolute_importance", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::relativeImportance, JsonpDeserializer.doubleDeserializer(), "relative_importance", new String[0]);
        op.add(Builder::supplied, JsonpDeserializer.booleanDeserializer(), "supplied", new String[0]);
        op.add(Builder::value, JsonpDeserializer.doubleDeserializer(), "value", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Hyperparameter> {
        @Nullable
        private Double absoluteImportance;
        private String name;
        @Nullable
        private Double relativeImportance;
        private Boolean supplied;
        private Double value;

        public Builder absoluteImportance(@Nullable Double value) {
            this.absoluteImportance = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder relativeImportance(@Nullable Double value) {
            this.relativeImportance = value;
            return this;
        }

        public Builder supplied(boolean value) {
            this.supplied = value;
            return this;
        }

        public Builder value(double value) {
            this.value = value;
            return this;
        }

        @Override
        public Hyperparameter build() {
            return new Hyperparameter(this);
        }
    }
}

