/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.Filter;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetFiltersResponse
implements JsonpSerializable {
    private final long count;
    private final List<Filter> filters;
    public static final JsonpDeserializer<GetFiltersResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetFiltersResponse::setupGetFiltersResponseDeserializer, Builder::build);

    public GetFiltersResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.filters = ModelTypeHelper.unmodifiableNonNull(builder.filters, "filters");
    }

    public GetFiltersResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("filters");
        generator.writeStartArray();
        for (Filter item0 : this.filters) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetFiltersResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::filters, JsonpDeserializer.arrayDeserializer(Filter._DESERIALIZER), "filters", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetFiltersResponse> {
        private Long count;
        private List<Filter> filters;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder filters(List<Filter> value) {
            this.filters = value;
            return this;
        }

        public Builder filters(Filter ... value) {
            this.filters = Arrays.asList(value);
            return this;
        }

        public Builder addFilters(Filter value) {
            if (this.filters == null) {
                this.filters = new ArrayList<Filter>();
            }
            this.filters.add(value);
            return this;
        }

        public Builder filters(Function<Filter.Builder, ObjectBuilder<Filter>> fn) {
            return this.filters(fn.apply(new Filter.Builder()).build());
        }

        public Builder addFilters(Function<Filter.Builder, ObjectBuilder<Filter>> fn) {
            return this.addFilters(fn.apply(new Filter.Builder()).build());
        }

        @Override
        public GetFiltersResponse build() {
            return new GetFiltersResponse(this);
        }
    }
}

