/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysis;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsDestination;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsSource;
import co.elastic.clients.elasticsearch.ml.ExplainDataFrameAnalyticsResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ExplainDataFrameAnalyticsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final DataframeAnalyticsSource source;
    @Nullable
    private final DataframeAnalyticsDestination dest;
    private final DataframeAnalysis analysis;
    @Nullable
    private final String description;
    @Nullable
    private final String modelMemoryLimit;
    @Nullable
    private final Integer maxNumThreads;
    @Nullable
    private final JsonValue analyzedFields;
    @Nullable
    private final Boolean allowLazyStart;
    public static final JsonpDeserializer<ExplainDataFrameAnalyticsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExplainDataFrameAnalyticsRequest::setupExplainDataFrameAnalyticsRequestDeserializer, Builder::build);
    public static final Endpoint<ExplainDataFrameAnalyticsRequest, ExplainDataFrameAnalyticsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ExplainDataFrameAnalyticsRequest, ExplainDataFrameAnalyticsResponse>(request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/_explain");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_explain");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ExplainDataFrameAnalyticsResponse._DESERIALIZER);

    public ExplainDataFrameAnalyticsRequest(Builder builder) {
        this.id = builder.id;
        this.source = builder.source;
        this.dest = builder.dest;
        this.analysis = Objects.requireNonNull(builder.analysis, "analysis");
        this.description = builder.description;
        this.modelMemoryLimit = builder.modelMemoryLimit;
        this.maxNumThreads = builder.maxNumThreads;
        this.analyzedFields = builder.analyzedFields;
        this.allowLazyStart = builder.allowLazyStart;
    }

    public ExplainDataFrameAnalyticsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public DataframeAnalyticsSource source() {
        return this.source;
    }

    @Nullable
    public DataframeAnalyticsDestination dest() {
        return this.dest;
    }

    public DataframeAnalysis analysis() {
        return this.analysis;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public String modelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    @Nullable
    public Integer maxNumThreads() {
        return this.maxNumThreads;
    }

    @Nullable
    public JsonValue analyzedFields() {
        return this.analyzedFields;
    }

    @Nullable
    public Boolean allowLazyStart() {
        return this.allowLazyStart;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.source != null) {
            generator.writeKey("source");
            this.source.serialize(generator, mapper);
        }
        if (this.dest != null) {
            generator.writeKey("dest");
            this.dest.serialize(generator, mapper);
        }
        generator.writeKey("analysis");
        this.analysis.serialize(generator, mapper);
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.modelMemoryLimit != null) {
            generator.writeKey("model_memory_limit");
            generator.write(this.modelMemoryLimit);
        }
        if (this.maxNumThreads != null) {
            generator.writeKey("max_num_threads");
            generator.write(this.maxNumThreads.intValue());
        }
        if (this.analyzedFields != null) {
            generator.writeKey("analyzed_fields");
            generator.write(this.analyzedFields);
        }
        if (this.allowLazyStart != null) {
            generator.writeKey("allow_lazy_start");
            generator.write(this.allowLazyStart.booleanValue());
        }
    }

    protected static void setupExplainDataFrameAnalyticsRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::source, DataframeAnalyticsSource._DESERIALIZER, "source", new String[0]);
        op.add(Builder::dest, DataframeAnalyticsDestination._DESERIALIZER, "dest", new String[0]);
        op.add(Builder::analysis, DataframeAnalysis._DESERIALIZER, "analysis", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::modelMemoryLimit, JsonpDeserializer.stringDeserializer(), "model_memory_limit", new String[0]);
        op.add(Builder::maxNumThreads, JsonpDeserializer.integerDeserializer(), "max_num_threads", new String[0]);
        op.add(Builder::analyzedFields, JsonpDeserializer.jsonValueDeserializer(), "analyzed_fields", new String[0]);
        op.add(Builder::allowLazyStart, JsonpDeserializer.booleanDeserializer(), "allow_lazy_start", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExplainDataFrameAnalyticsRequest> {
        @Nullable
        private String id;
        @Nullable
        private DataframeAnalyticsSource source;
        @Nullable
        private DataframeAnalyticsDestination dest;
        private DataframeAnalysis analysis;
        @Nullable
        private String description;
        @Nullable
        private String modelMemoryLimit;
        @Nullable
        private Integer maxNumThreads;
        @Nullable
        private JsonValue analyzedFields;
        @Nullable
        private Boolean allowLazyStart;

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder source(@Nullable DataframeAnalyticsSource value) {
            this.source = value;
            return this;
        }

        public Builder source(Function<DataframeAnalyticsSource.Builder, ObjectBuilder<DataframeAnalyticsSource>> fn) {
            return this.source(fn.apply(new DataframeAnalyticsSource.Builder()).build());
        }

        public Builder dest(@Nullable DataframeAnalyticsDestination value) {
            this.dest = value;
            return this;
        }

        public Builder dest(Function<DataframeAnalyticsDestination.Builder, ObjectBuilder<DataframeAnalyticsDestination>> fn) {
            return this.dest(fn.apply(new DataframeAnalyticsDestination.Builder()).build());
        }

        public Builder analysis(DataframeAnalysis value) {
            this.analysis = value;
            return this;
        }

        public Builder analysis(Function<DataframeAnalysis.Builder, ObjectBuilder<DataframeAnalysis>> fn) {
            return this.analysis(fn.apply(new DataframeAnalysis.Builder()).build());
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder modelMemoryLimit(@Nullable String value) {
            this.modelMemoryLimit = value;
            return this;
        }

        public Builder maxNumThreads(@Nullable Integer value) {
            this.maxNumThreads = value;
            return this;
        }

        public Builder analyzedFields(@Nullable JsonValue value) {
            this.analyzedFields = value;
            return this;
        }

        public Builder allowLazyStart(@Nullable Boolean value) {
            this.allowLazyStart = value;
            return this;
        }

        @Override
        public ExplainDataFrameAnalyticsRequest build() {
            return new ExplainDataFrameAnalyticsRequest(this);
        }
    }
}

