/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeEvaluationClassification;
import co.elastic.clients.elasticsearch.ml.DataframeEvaluationOutlierDetection;
import co.elastic.clients.elasticsearch.ml.DataframeEvaluationRegression;
import co.elastic.clients.elasticsearch.ml.DataframeEvaluationVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class DataframeEvaluation
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String CLASSIFICATION = "classification";
    public static final String OUTLIER_DETECTION = "outlier_detection";
    public static final String REGRESSION = "regression";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<DataframeEvaluation> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, DataframeEvaluation::setupDataframeEvaluationDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public DataframeEvaluation(DataframeEvaluationVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    public <T extends DataframeEvaluationVariant> DataframeEvaluation(ObjectBuilder<T> builder) {
        this((DataframeEvaluationVariant)builder.build());
    }

    private DataframeEvaluation(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public DataframeEvaluation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public DataframeEvaluationClassification classification() {
        return (DataframeEvaluationClassification)TaggedUnionUtils.get(this, CLASSIFICATION);
    }

    public DataframeEvaluationOutlierDetection outlierDetection() {
        return (DataframeEvaluationOutlierDetection)TaggedUnionUtils.get(this, OUTLIER_DETECTION);
    }

    public DataframeEvaluationRegression regression() {
        return (DataframeEvaluationRegression)TaggedUnionUtils.get(this, REGRESSION);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupDataframeEvaluationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::classification, DataframeEvaluationClassification._DESERIALIZER, CLASSIFICATION, new String[0]);
        op.add(Builder::outlierDetection, DataframeEvaluationOutlierDetection._DESERIALIZER, OUTLIER_DETECTION, new String[0]);
        op.add(Builder::regression, DataframeEvaluationRegression._DESERIALIZER, REGRESSION, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataframeEvaluation> {
        private String _type;
        private Object _value;

        public Builder classification(DataframeEvaluationClassification v) {
            this._type = DataframeEvaluation.CLASSIFICATION;
            this._value = v;
            return this;
        }

        public Builder classification(Function<DataframeEvaluationClassification.Builder, ObjectBuilder<DataframeEvaluationClassification>> f) {
            return this.classification(f.apply(new DataframeEvaluationClassification.Builder()).build());
        }

        public Builder outlierDetection(DataframeEvaluationOutlierDetection v) {
            this._type = DataframeEvaluation.OUTLIER_DETECTION;
            this._value = v;
            return this;
        }

        public Builder outlierDetection(Function<DataframeEvaluationOutlierDetection.Builder, ObjectBuilder<DataframeEvaluationOutlierDetection>> f) {
            return this.outlierDetection(f.apply(new DataframeEvaluationOutlierDetection.Builder()).build());
        }

        public Builder regression(DataframeEvaluationRegression v) {
            this._type = DataframeEvaluation.REGRESSION;
            this._value = v;
            return this;
        }

        public Builder regression(Function<DataframeEvaluationRegression.Builder, ObjectBuilder<DataframeEvaluationRegression>> f) {
            return this.regression(f.apply(new DataframeEvaluationRegression.Builder()).build());
        }

        @Override
        public DataframeEvaluation build() {
            return new DataframeEvaluation(this);
        }
    }
}

