/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DatafeedTimingStats
implements JsonpSerializable {
    private final long bucketCount;
    private final double exponentialAverageSearchTimePerHourMs;
    private final String jobId;
    private final long searchCount;
    private final double totalSearchTimeMs;
    private final Number averageSearchTimePerBucketMs;
    public static final JsonpDeserializer<DatafeedTimingStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DatafeedTimingStats::setupDatafeedTimingStatsDeserializer, Builder::build);

    public DatafeedTimingStats(Builder builder) {
        this.bucketCount = Objects.requireNonNull(builder.bucketCount, "bucket_count");
        this.exponentialAverageSearchTimePerHourMs = Objects.requireNonNull(builder.exponentialAverageSearchTimePerHourMs, "exponential_average_search_time_per_hour_ms");
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.searchCount = Objects.requireNonNull(builder.searchCount, "search_count");
        this.totalSearchTimeMs = Objects.requireNonNull(builder.totalSearchTimeMs, "total_search_time_ms");
        this.averageSearchTimePerBucketMs = Objects.requireNonNull(builder.averageSearchTimePerBucketMs, "average_search_time_per_bucket_ms");
    }

    public DatafeedTimingStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long bucketCount() {
        return this.bucketCount;
    }

    public double exponentialAverageSearchTimePerHourMs() {
        return this.exponentialAverageSearchTimePerHourMs;
    }

    public String jobId() {
        return this.jobId;
    }

    public long searchCount() {
        return this.searchCount;
    }

    public double totalSearchTimeMs() {
        return this.totalSearchTimeMs;
    }

    public Number averageSearchTimePerBucketMs() {
        return this.averageSearchTimePerBucketMs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bucket_count");
        generator.write(this.bucketCount);
        generator.writeKey("exponential_average_search_time_per_hour_ms");
        generator.write(this.exponentialAverageSearchTimePerHourMs);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("search_count");
        generator.write(this.searchCount);
        generator.writeKey("total_search_time_ms");
        generator.write(this.totalSearchTimeMs);
        generator.writeKey("average_search_time_per_bucket_ms");
        generator.write(this.averageSearchTimePerBucketMs.doubleValue());
    }

    protected static void setupDatafeedTimingStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::bucketCount, JsonpDeserializer.longDeserializer(), "bucket_count", new String[0]);
        op.add(Builder::exponentialAverageSearchTimePerHourMs, JsonpDeserializer.doubleDeserializer(), "exponential_average_search_time_per_hour_ms", new String[0]);
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id", new String[0]);
        op.add(Builder::searchCount, JsonpDeserializer.longDeserializer(), "search_count", new String[0]);
        op.add(Builder::totalSearchTimeMs, JsonpDeserializer.doubleDeserializer(), "total_search_time_ms", new String[0]);
        op.add(Builder::averageSearchTimePerBucketMs, JsonpDeserializer.numberDeserializer(), "average_search_time_per_bucket_ms", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DatafeedTimingStats> {
        private Long bucketCount;
        private Double exponentialAverageSearchTimePerHourMs;
        private String jobId;
        private Long searchCount;
        private Double totalSearchTimeMs;
        private Number averageSearchTimePerBucketMs;

        public Builder bucketCount(long value) {
            this.bucketCount = value;
            return this;
        }

        public Builder exponentialAverageSearchTimePerHourMs(double value) {
            this.exponentialAverageSearchTimePerHourMs = value;
            return this;
        }

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder searchCount(long value) {
            this.searchCount = value;
            return this;
        }

        public Builder totalSearchTimeMs(double value) {
            this.totalSearchTimeMs = value;
            return this;
        }

        public Builder averageSearchTimePerBucketMs(Number value) {
            this.averageSearchTimePerBucketMs = value;
            return this;
        }

        @Override
        public DatafeedTimingStats build() {
            return new DatafeedTimingStats(this);
        }
    }
}

