/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.ml.ChunkingConfig;
import co.elastic.clients.elasticsearch.ml.DatafeedIndicesOptions;
import co.elastic.clients.elasticsearch.ml.DelayedDataCheckConfig;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DatafeedConfig
implements JsonpSerializable {
    @Nullable
    private final Map<String, Aggregation> aggregations;
    @Nullable
    private final Map<String, Aggregation> aggs;
    @Nullable
    private final ChunkingConfig chunkingConfig;
    @Nullable
    private final String datafeedId;
    @Nullable
    private final DelayedDataCheckConfig delayedDataCheckConfig;
    @Nullable
    private final String frequency;
    @Nullable
    private final List<String> indexes;
    private final List<String> indices;
    @Nullable
    private final DatafeedIndicesOptions indicesOptions;
    @Nullable
    private final String jobId;
    @Nullable
    private final Integer maxEmptySearches;
    private final Query query;
    @Nullable
    private final String queryDelay;
    @Nullable
    private final Map<String, RuntimeField> runtimeMappings;
    @Nullable
    private final Map<String, ScriptField> scriptFields;
    @Nullable
    private final Integer scrollSize;
    public static final JsonpDeserializer<DatafeedConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DatafeedConfig::setupDatafeedConfigDeserializer, Builder::build);

    public DatafeedConfig(Builder builder) {
        this.aggregations = ModelTypeHelper.unmodifiable(builder.aggregations);
        this.aggs = ModelTypeHelper.unmodifiable(builder.aggs);
        this.chunkingConfig = builder.chunkingConfig;
        this.datafeedId = builder.datafeedId;
        this.delayedDataCheckConfig = builder.delayedDataCheckConfig;
        this.frequency = builder.frequency;
        this.indexes = ModelTypeHelper.unmodifiable(builder.indexes);
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.indicesOptions = builder.indicesOptions;
        this.jobId = builder.jobId;
        this.maxEmptySearches = builder.maxEmptySearches;
        this.query = Objects.requireNonNull(builder.query, "query");
        this.queryDelay = builder.queryDelay;
        this.runtimeMappings = ModelTypeHelper.unmodifiable(builder.runtimeMappings);
        this.scriptFields = ModelTypeHelper.unmodifiable(builder.scriptFields);
        this.scrollSize = builder.scrollSize;
    }

    public DatafeedConfig(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public Map<String, Aggregation> aggs() {
        return this.aggs;
    }

    @Nullable
    public ChunkingConfig chunkingConfig() {
        return this.chunkingConfig;
    }

    @Nullable
    public String datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public DelayedDataCheckConfig delayedDataCheckConfig() {
        return this.delayedDataCheckConfig;
    }

    @Nullable
    public String frequency() {
        return this.frequency;
    }

    @Nullable
    public List<String> indexes() {
        return this.indexes;
    }

    public List<String> indices() {
        return this.indices;
    }

    @Nullable
    public DatafeedIndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Nullable
    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public Integer maxEmptySearches() {
        return this.maxEmptySearches;
    }

    public Query query() {
        return this.query;
    }

    @Nullable
    public String queryDelay() {
        return this.queryDelay;
    }

    @Nullable
    public Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    @Nullable
    public Map<String, ScriptField> scriptFields() {
        return this.scriptFields;
    }

    @Nullable
    public Integer scrollSize() {
        return this.scrollSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aggregations != null) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.aggs != null) {
            generator.writeKey("aggs");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggs.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.chunkingConfig != null) {
            generator.writeKey("chunking_config");
            this.chunkingConfig.serialize(generator, mapper);
        }
        if (this.datafeedId != null) {
            generator.writeKey("datafeed_id");
            generator.write(this.datafeedId);
        }
        if (this.delayedDataCheckConfig != null) {
            generator.writeKey("delayed_data_check_config");
            this.delayedDataCheckConfig.serialize(generator, mapper);
        }
        if (this.frequency != null) {
            generator.writeKey("frequency");
            generator.write(this.frequency);
        }
        if (this.indexes != null) {
            generator.writeKey("indexes");
            generator.writeStartArray();
            for (String string : this.indexes) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("indices");
        generator.writeStartArray();
        for (String string : this.indices) {
            generator.write(string);
        }
        generator.writeEnd();
        if (this.indicesOptions != null) {
            generator.writeKey("indices_options");
            this.indicesOptions.serialize(generator, mapper);
        }
        if (this.jobId != null) {
            generator.writeKey("job_id");
            generator.write(this.jobId);
        }
        if (this.maxEmptySearches != null) {
            generator.writeKey("max_empty_searches");
            generator.write(this.maxEmptySearches.intValue());
        }
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        if (this.queryDelay != null) {
            generator.writeKey("query_delay");
            generator.write(this.queryDelay);
        }
        if (this.runtimeMappings != null) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.scriptFields != null) {
            generator.writeKey("script_fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptFields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ScriptField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.scrollSize != null) {
            generator.writeKey("scroll_size");
            generator.write(this.scrollSize.intValue());
        }
    }

    protected static void setupDatafeedConfigDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations", new String[0]);
        op.add(Builder::aggs, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggs", new String[0]);
        op.add(Builder::chunkingConfig, ChunkingConfig._DESERIALIZER, "chunking_config", new String[0]);
        op.add(Builder::datafeedId, JsonpDeserializer.stringDeserializer(), "datafeed_id", new String[0]);
        op.add(Builder::delayedDataCheckConfig, DelayedDataCheckConfig._DESERIALIZER, "delayed_data_check_config", new String[0]);
        op.add(Builder::frequency, JsonpDeserializer.stringDeserializer(), "frequency", new String[0]);
        op.add(Builder::indexes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indexes", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices", new String[0]);
        op.add(Builder::indicesOptions, DatafeedIndicesOptions._DESERIALIZER, "indices_options", new String[0]);
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id", new String[0]);
        op.add(Builder::maxEmptySearches, JsonpDeserializer.integerDeserializer(), "max_empty_searches", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::queryDelay, JsonpDeserializer.stringDeserializer(), "query_delay", new String[0]);
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings", new String[0]);
        op.add(Builder::scriptFields, JsonpDeserializer.stringMapDeserializer(ScriptField._DESERIALIZER), "script_fields", new String[0]);
        op.add(Builder::scrollSize, JsonpDeserializer.integerDeserializer(), "scroll_size", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DatafeedConfig> {
        @Nullable
        private Map<String, Aggregation> aggregations;
        @Nullable
        private Map<String, Aggregation> aggs;
        @Nullable
        private ChunkingConfig chunkingConfig;
        @Nullable
        private String datafeedId;
        @Nullable
        private DelayedDataCheckConfig delayedDataCheckConfig;
        @Nullable
        private String frequency;
        @Nullable
        private List<String> indexes;
        private List<String> indices;
        @Nullable
        private DatafeedIndicesOptions indicesOptions;
        @Nullable
        private String jobId;
        @Nullable
        private Integer maxEmptySearches;
        private Query query;
        @Nullable
        private String queryDelay;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;
        @Nullable
        private Map<String, ScriptField> scriptFields;
        @Nullable
        private Integer scrollSize;

        public Builder aggregations(@Nullable Map<String, Aggregation> value) {
            this.aggregations = value;
            return this;
        }

        public Builder putAggregations(String key, Aggregation value) {
            if (this.aggregations == null) {
                this.aggregations = new HashMap<String, Aggregation>();
            }
            this.aggregations.put(key, value);
            return this;
        }

        public Builder aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(Collections.singletonMap(key, fn.apply(new Aggregation.Builder()).build()));
        }

        public Builder putAggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.putAggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        public Builder aggs(@Nullable Map<String, Aggregation> value) {
            this.aggs = value;
            return this;
        }

        public Builder putAggs(String key, Aggregation value) {
            if (this.aggs == null) {
                this.aggs = new HashMap<String, Aggregation>();
            }
            this.aggs.put(key, value);
            return this;
        }

        public Builder aggs(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggs(Collections.singletonMap(key, fn.apply(new Aggregation.Builder()).build()));
        }

        public Builder putAggs(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.putAggs(key, fn.apply(new Aggregation.Builder()).build());
        }

        public Builder chunkingConfig(@Nullable ChunkingConfig value) {
            this.chunkingConfig = value;
            return this;
        }

        public Builder chunkingConfig(Function<ChunkingConfig.Builder, ObjectBuilder<ChunkingConfig>> fn) {
            return this.chunkingConfig(fn.apply(new ChunkingConfig.Builder()).build());
        }

        public Builder datafeedId(@Nullable String value) {
            this.datafeedId = value;
            return this;
        }

        public Builder delayedDataCheckConfig(@Nullable DelayedDataCheckConfig value) {
            this.delayedDataCheckConfig = value;
            return this;
        }

        public Builder delayedDataCheckConfig(Function<DelayedDataCheckConfig.Builder, ObjectBuilder<DelayedDataCheckConfig>> fn) {
            return this.delayedDataCheckConfig(fn.apply(new DelayedDataCheckConfig.Builder()).build());
        }

        public Builder frequency(@Nullable String value) {
            this.frequency = value;
            return this;
        }

        public Builder indexes(@Nullable List<String> value) {
            this.indexes = value;
            return this;
        }

        public Builder indexes(String ... value) {
            this.indexes = Arrays.asList(value);
            return this;
        }

        public Builder addIndexes(String value) {
            if (this.indexes == null) {
                this.indexes = new ArrayList<String>();
            }
            this.indexes.add(value);
            return this;
        }

        public Builder indices(List<String> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(String ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(String value) {
            if (this.indices == null) {
                this.indices = new ArrayList<String>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder indicesOptions(@Nullable DatafeedIndicesOptions value) {
            this.indicesOptions = value;
            return this;
        }

        public Builder indicesOptions(Function<DatafeedIndicesOptions.Builder, ObjectBuilder<DatafeedIndicesOptions>> fn) {
            return this.indicesOptions(fn.apply(new DatafeedIndicesOptions.Builder()).build());
        }

        public Builder jobId(@Nullable String value) {
            this.jobId = value;
            return this;
        }

        public Builder maxEmptySearches(@Nullable Integer value) {
            this.maxEmptySearches = value;
            return this;
        }

        public Builder query(Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder queryDelay(@Nullable String value) {
            this.queryDelay = value;
            return this;
        }

        public Builder runtimeMappings(@Nullable Map<String, RuntimeField> value) {
            this.runtimeMappings = value;
            return this;
        }

        public Builder putRuntimeMappings(String key, RuntimeField value) {
            if (this.runtimeMappings == null) {
                this.runtimeMappings = new HashMap<String, RuntimeField>();
            }
            this.runtimeMappings.put(key, value);
            return this;
        }

        public Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(Collections.singletonMap(key, fn.apply(new RuntimeField.Builder()).build()));
        }

        public Builder putRuntimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.putRuntimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public Builder scriptFields(@Nullable Map<String, ScriptField> value) {
            this.scriptFields = value;
            return this;
        }

        public Builder putScriptFields(String key, ScriptField value) {
            if (this.scriptFields == null) {
                this.scriptFields = new HashMap<String, ScriptField>();
            }
            this.scriptFields.put(key, value);
            return this;
        }

        public Builder scriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.scriptFields(Collections.singletonMap(key, fn.apply(new ScriptField.Builder()).build()));
        }

        public Builder putScriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.putScriptFields(key, fn.apply(new ScriptField.Builder()).build());
        }

        public Builder scrollSize(@Nullable Integer value) {
            this.scrollSize = value;
            return this;
        }

        @Override
        public DatafeedConfig build() {
            return new DatafeedConfig(this);
        }
    }
}

