/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CalendarEvent
implements JsonpSerializable {
    @Nullable
    private final String calendarId;
    @Nullable
    private final String eventId;
    private final String description;
    private final String endTime;
    private final String startTime;
    public static final JsonpDeserializer<CalendarEvent> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CalendarEvent::setupCalendarEventDeserializer, Builder::build);

    public CalendarEvent(Builder builder) {
        this.calendarId = builder.calendarId;
        this.eventId = builder.eventId;
        this.description = Objects.requireNonNull(builder.description, "description");
        this.endTime = Objects.requireNonNull(builder.endTime, "end_time");
        this.startTime = Objects.requireNonNull(builder.startTime, "start_time");
    }

    public CalendarEvent(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String calendarId() {
        return this.calendarId;
    }

    @Nullable
    public String eventId() {
        return this.eventId;
    }

    public String description() {
        return this.description;
    }

    public String endTime() {
        return this.endTime;
    }

    public String startTime() {
        return this.startTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.calendarId != null) {
            generator.writeKey("calendar_id");
            generator.write(this.calendarId);
        }
        if (this.eventId != null) {
            generator.writeKey("event_id");
            generator.write(this.eventId);
        }
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("end_time");
        generator.write(this.endTime);
        generator.writeKey("start_time");
        generator.write(this.startTime);
    }

    protected static void setupCalendarEventDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::calendarId, JsonpDeserializer.stringDeserializer(), "calendar_id", new String[0]);
        op.add(Builder::eventId, JsonpDeserializer.stringDeserializer(), "event_id", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::endTime, JsonpDeserializer.stringDeserializer(), "end_time", new String[0]);
        op.add(Builder::startTime, JsonpDeserializer.stringDeserializer(), "start_time", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CalendarEvent> {
        @Nullable
        private String calendarId;
        @Nullable
        private String eventId;
        private String description;
        private String endTime;
        private String startTime;

        public Builder calendarId(@Nullable String value) {
            this.calendarId = value;
            return this;
        }

        public Builder eventId(@Nullable String value) {
            this.eventId = value;
            return this;
        }

        public Builder description(String value) {
            this.description = value;
            return this;
        }

        public Builder endTime(String value) {
            this.endTime = value;
            return this;
        }

        public Builder startTime(String value) {
            this.startTime = value;
            return this;
        }

        @Override
        public CalendarEvent build() {
            return new CalendarEvent(this);
        }
    }
}

