/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.migration.deprecations;

import co.elastic.clients.elasticsearch.migration.deprecations.DeprecationLevel;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Deprecation
implements JsonpSerializable {
    private final String details;
    private final DeprecationLevel level;
    private final String message;
    private final String url;
    public static final JsonpDeserializer<Deprecation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Deprecation::setupDeprecationDeserializer, Builder::build);

    public Deprecation(Builder builder) {
        this.details = Objects.requireNonNull(builder.details, "details");
        this.level = Objects.requireNonNull(builder.level, "level");
        this.message = Objects.requireNonNull(builder.message, "message");
        this.url = Objects.requireNonNull(builder.url, "url");
    }

    public Deprecation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String details() {
        return this.details;
    }

    public DeprecationLevel level() {
        return this.level;
    }

    public String message() {
        return this.message;
    }

    public String url() {
        return this.url;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("details");
        generator.write(this.details);
        generator.writeKey("level");
        this.level.serialize(generator, mapper);
        generator.writeKey("message");
        generator.write(this.message);
        generator.writeKey("url");
        generator.write(this.url);
    }

    protected static void setupDeprecationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::details, JsonpDeserializer.stringDeserializer(), "details", new String[0]);
        op.add(Builder::level, DeprecationLevel._DESERIALIZER, "level", new String[0]);
        op.add(Builder::message, JsonpDeserializer.stringDeserializer(), "message", new String[0]);
        op.add(Builder::url, JsonpDeserializer.stringDeserializer(), "url", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Deprecation> {
        private String details;
        private DeprecationLevel level;
        private String message;
        private String url;

        public Builder details(String value) {
            this.details = value;
            return this;
        }

        public Builder level(DeprecationLevel value) {
            this.level = value;
            return this;
        }

        public Builder message(String value) {
            this.message = value;
            return this;
        }

        public Builder url(String value) {
            this.url = value;
            return this;
        }

        @Override
        public Deprecation build() {
            return new Deprecation(this);
        }
    }
}

