/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponseBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PostStartBasicResponse
extends AcknowledgedResponseBase {
    private final Map<String, List<String>> acknowledge;
    private final boolean basicWasStarted;
    private final String errorMessage;
    public static final JsonpDeserializer<PostStartBasicResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostStartBasicResponse::setupPostStartBasicResponseDeserializer, Builder::build);

    public PostStartBasicResponse(Builder builder) {
        super(builder);
        this.acknowledge = ModelTypeHelper.unmodifiableNonNull(builder.acknowledge, "acknowledge");
        this.basicWasStarted = Objects.requireNonNull(builder.basicWasStarted, "basic_was_started");
        this.errorMessage = Objects.requireNonNull(builder.errorMessage, "error_message");
    }

    public PostStartBasicResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, List<String>> acknowledge() {
        return this.acknowledge;
    }

    public boolean basicWasStarted() {
        return this.basicWasStarted;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("acknowledge");
        generator.writeStartObject();
        for (Map.Entry<String, List<String>> item0 : this.acknowledge.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.writeStartArray();
            for (String item1 : item0.getValue()) {
                generator.write(item1);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
        generator.writeKey("basic_was_started");
        generator.write(this.basicWasStarted);
        generator.writeKey("error_message");
        generator.write(this.errorMessage);
    }

    protected static void setupPostStartBasicResponseDeserializer(DelegatingDeserializer<Builder> op) {
        AcknowledgedResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::acknowledge, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "acknowledge", new String[0]);
        op.add(Builder::basicWasStarted, JsonpDeserializer.booleanDeserializer(), "basic_was_started", new String[0]);
        op.add(Builder::errorMessage, JsonpDeserializer.stringDeserializer(), "error_message", new String[0]);
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PostStartBasicResponse> {
        private Map<String, List<String>> acknowledge;
        private Boolean basicWasStarted;
        private String errorMessage;

        public Builder acknowledge(Map<String, List<String>> value) {
            this.acknowledge = value;
            return this;
        }

        public Builder putAcknowledge(String key, List<String> value) {
            if (this.acknowledge == null) {
                this.acknowledge = new HashMap<String, List<String>>();
            }
            this.acknowledge.put(key, value);
            return this;
        }

        public Builder basicWasStarted(boolean value) {
            this.basicWasStarted = value;
            return this;
        }

        public Builder errorMessage(String value) {
            this.errorMessage = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PostStartBasicResponse build() {
            return new PostStartBasicResponse(this);
        }
    }
}

