/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardPath
implements JsonpSerializable {
    private final String dataPath;
    private final boolean isCustomDataPath;
    private final String statePath;
    public static final JsonpDeserializer<ShardPath> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardPath::setupShardPathDeserializer, Builder::build);

    public ShardPath(Builder builder) {
        this.dataPath = Objects.requireNonNull(builder.dataPath, "data_path");
        this.isCustomDataPath = Objects.requireNonNull(builder.isCustomDataPath, "is_custom_data_path");
        this.statePath = Objects.requireNonNull(builder.statePath, "state_path");
    }

    public ShardPath(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String dataPath() {
        return this.dataPath;
    }

    public boolean isCustomDataPath() {
        return this.isCustomDataPath;
    }

    public String statePath() {
        return this.statePath;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("data_path");
        generator.write(this.dataPath);
        generator.writeKey("is_custom_data_path");
        generator.write(this.isCustomDataPath);
        generator.writeKey("state_path");
        generator.write(this.statePath);
    }

    protected static void setupShardPathDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::dataPath, JsonpDeserializer.stringDeserializer(), "data_path", new String[0]);
        op.add(Builder::isCustomDataPath, JsonpDeserializer.booleanDeserializer(), "is_custom_data_path", new String[0]);
        op.add(Builder::statePath, JsonpDeserializer.stringDeserializer(), "state_path", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardPath> {
        private String dataPath;
        private Boolean isCustomDataPath;
        private String statePath;

        public Builder dataPath(String value) {
            this.dataPath = value;
            return this;
        }

        public Builder isCustomDataPath(boolean value) {
            this.isCustomDataPath = value;
            return this;
        }

        public Builder statePath(String value) {
            this.statePath = value;
            return this;
        }

        @Override
        public ShardPath build() {
            return new ShardPath(this);
        }
    }
}

