/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.elasticsearch.indices.stats.IndexStats;
import co.elastic.clients.elasticsearch.indices.stats.ShardStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndicesStats
implements JsonpSerializable {
    private final IndexStats primaries;
    @Nullable
    private final Map<String, List<ShardStats>> shards;
    private final IndexStats total;
    @Nullable
    private final String uuid;
    public static final JsonpDeserializer<IndicesStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesStats::setupIndicesStatsDeserializer, Builder::build);

    public IndicesStats(Builder builder) {
        this.primaries = Objects.requireNonNull(builder.primaries, "primaries");
        this.shards = ModelTypeHelper.unmodifiable(builder.shards);
        this.total = Objects.requireNonNull(builder.total, "total");
        this.uuid = builder.uuid;
    }

    public IndicesStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public IndexStats primaries() {
        return this.primaries;
    }

    @Nullable
    public Map<String, List<ShardStats>> shards() {
        return this.shards;
    }

    public IndexStats total() {
        return this.total;
    }

    @Nullable
    public String uuid() {
        return this.uuid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("primaries");
        this.primaries.serialize(generator, mapper);
        if (this.shards != null) {
            generator.writeKey("shards");
            generator.writeStartObject();
            for (Map.Entry<String, List<ShardStats>> item0 : this.shards.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                for (ShardStats item1 : item0.getValue()) {
                    item1.serialize(generator, mapper);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
        if (this.uuid != null) {
            generator.writeKey("uuid");
            generator.write(this.uuid);
        }
    }

    protected static void setupIndicesStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::primaries, IndexStats._DESERIALIZER, "primaries", new String[0]);
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(ShardStats._DESERIALIZER)), "shards", new String[0]);
        op.add(Builder::total, IndexStats._DESERIALIZER, "total", new String[0]);
        op.add(Builder::uuid, JsonpDeserializer.stringDeserializer(), "uuid", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndicesStats> {
        private IndexStats primaries;
        @Nullable
        private Map<String, List<ShardStats>> shards;
        private IndexStats total;
        @Nullable
        private String uuid;

        public Builder primaries(IndexStats value) {
            this.primaries = value;
            return this;
        }

        public Builder primaries(Function<IndexStats.Builder, ObjectBuilder<IndexStats>> fn) {
            return this.primaries(fn.apply(new IndexStats.Builder()).build());
        }

        public Builder shards(@Nullable Map<String, List<ShardStats>> value) {
            this.shards = value;
            return this;
        }

        public Builder putShards(String key, List<ShardStats> value) {
            if (this.shards == null) {
                this.shards = new HashMap<String, List<ShardStats>>();
            }
            this.shards.put(key, value);
            return this;
        }

        public Builder total(IndexStats value) {
            this.total = value;
            return this;
        }

        public Builder total(Function<IndexStats.Builder, ObjectBuilder<IndexStats>> fn) {
            return this.total(fn.apply(new IndexStats.Builder()).build());
        }

        public Builder uuid(@Nullable String value) {
            this.uuid = value;
            return this;
        }

        @Override
        public IndicesStats build() {
            return new IndicesStats(this);
        }
    }
}

