/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.resolve_index;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ResolveIndexAliasItem
implements JsonpSerializable {
    private final String name;
    private final List<String> indices;
    public static final JsonpDeserializer<ResolveIndexAliasItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResolveIndexAliasItem::setupResolveIndexAliasItemDeserializer, Builder::build);

    public ResolveIndexAliasItem(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
    }

    public ResolveIndexAliasItem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public List<String> indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("indices");
        generator.writeStartArray();
        for (String item0 : this.indices) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupResolveIndexAliasItemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ResolveIndexAliasItem> {
        private String name;
        private List<String> indices;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder indices(List<String> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(String ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(String value) {
            if (this.indices == null) {
                this.indices = new ArrayList<String>();
            }
            this.indices.add(value);
            return this;
        }

        @Override
        public ResolveIndexAliasItem build() {
            return new ResolveIndexAliasItem(this);
        }
    }
}

