/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_index_template;

import co.elastic.clients.elasticsearch.indices.get_index_template.IndexTemplateSummary;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndexTemplate
implements JsonpSerializable {
    private final List<String> indexPatterns;
    private final List<String> composedOf;
    private final IndexTemplateSummary template;
    @Nullable
    private final Long version;
    @Nullable
    private final Long priority;
    @Nullable
    private final Map<String, JsonData> meta;
    @Nullable
    private final Boolean allowAutoCreate;
    @Nullable
    private final Map<String, JsonData> dataStream;
    public static final JsonpDeserializer<IndexTemplate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexTemplate::setupIndexTemplateDeserializer, Builder::build);

    public IndexTemplate(Builder builder) {
        this.indexPatterns = ModelTypeHelper.unmodifiableNonNull(builder.indexPatterns, "index_patterns");
        this.composedOf = ModelTypeHelper.unmodifiableNonNull(builder.composedOf, "composed_of");
        this.template = Objects.requireNonNull(builder.template, "template");
        this.version = builder.version;
        this.priority = builder.priority;
        this.meta = ModelTypeHelper.unmodifiable(builder.meta);
        this.allowAutoCreate = builder.allowAutoCreate;
        this.dataStream = ModelTypeHelper.unmodifiable(builder.dataStream);
    }

    public IndexTemplate(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> indexPatterns() {
        return this.indexPatterns;
    }

    public List<String> composedOf() {
        return this.composedOf;
    }

    public IndexTemplateSummary template() {
        return this.template;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public Long priority() {
        return this.priority;
    }

    @Nullable
    public Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public Boolean allowAutoCreate() {
        return this.allowAutoCreate;
    }

    @Nullable
    public Map<String, JsonData> dataStream() {
        return this.dataStream;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index_patterns");
        generator.writeStartArray();
        for (String string : this.indexPatterns) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("composed_of");
        generator.writeStartArray();
        for (String string : this.composedOf) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("template");
        this.template.serialize(generator, mapper);
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.priority != null) {
            generator.writeKey("priority");
            generator.write(this.priority.longValue());
        }
        if (this.meta != null) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.allowAutoCreate != null) {
            generator.writeKey("allow_auto_create");
            generator.write(this.allowAutoCreate.booleanValue());
        }
        if (this.dataStream != null) {
            generator.writeKey("data_stream");
            generator.writeStartObject();
            for (Map.Entry entry : this.dataStream.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupIndexTemplateDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns", new String[0]);
        op.add(Builder::composedOf, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "composed_of", new String[0]);
        op.add(Builder::template, IndexTemplateSummary._DESERIALIZER, "template", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(Builder::priority, JsonpDeserializer.longDeserializer(), "priority", new String[0]);
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta", new String[0]);
        op.add(Builder::allowAutoCreate, JsonpDeserializer.booleanDeserializer(), "allow_auto_create", new String[0]);
        op.add(Builder::dataStream, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "data_stream", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexTemplate> {
        private List<String> indexPatterns;
        private List<String> composedOf;
        private IndexTemplateSummary template;
        @Nullable
        private Long version;
        @Nullable
        private Long priority;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Boolean allowAutoCreate;
        @Nullable
        private Map<String, JsonData> dataStream;

        public Builder indexPatterns(List<String> value) {
            this.indexPatterns = value;
            return this;
        }

        public Builder indexPatterns(String ... value) {
            this.indexPatterns = Arrays.asList(value);
            return this;
        }

        public Builder addIndexPatterns(String value) {
            if (this.indexPatterns == null) {
                this.indexPatterns = new ArrayList<String>();
            }
            this.indexPatterns.add(value);
            return this;
        }

        public Builder composedOf(List<String> value) {
            this.composedOf = value;
            return this;
        }

        public Builder composedOf(String ... value) {
            this.composedOf = Arrays.asList(value);
            return this;
        }

        public Builder addComposedOf(String value) {
            if (this.composedOf == null) {
                this.composedOf = new ArrayList<String>();
            }
            this.composedOf.add(value);
            return this;
        }

        public Builder template(IndexTemplateSummary value) {
            this.template = value;
            return this;
        }

        public Builder template(Function<IndexTemplateSummary.Builder, ObjectBuilder<IndexTemplateSummary>> fn) {
            return this.template(fn.apply(new IndexTemplateSummary.Builder()).build());
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder priority(@Nullable Long value) {
            this.priority = value;
            return this;
        }

        public Builder meta(@Nullable Map<String, JsonData> value) {
            this.meta = value;
            return this;
        }

        public Builder putMeta(String key, JsonData value) {
            if (this.meta == null) {
                this.meta = new HashMap<String, JsonData>();
            }
            this.meta.put(key, value);
            return this;
        }

        public Builder allowAutoCreate(@Nullable Boolean value) {
            this.allowAutoCreate = value;
            return this;
        }

        public Builder dataStream(@Nullable Map<String, JsonData> value) {
            this.dataStream = value;
            return this;
        }

        public Builder putDataStream(String key, JsonData value) {
            if (this.dataStream == null) {
                this.dataStream = new HashMap<String, JsonData>();
            }
            this.dataStream.put(key, value);
            return this;
        }

        @Override
        public IndexTemplate build() {
            return new IndexTemplate(this);
        }
    }
}

