/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.indices.validate_query.IndicesValidationExplanation;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ValidateQueryResponse
implements JsonpSerializable {
    @Nullable
    private final List<IndicesValidationExplanation> explanations;
    @Nullable
    private final ShardStatistics shards;
    private final boolean valid;
    @Nullable
    private final String error;
    public static final JsonpDeserializer<ValidateQueryResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ValidateQueryResponse::setupValidateQueryResponseDeserializer, Builder::build);

    public ValidateQueryResponse(Builder builder) {
        this.explanations = ModelTypeHelper.unmodifiable(builder.explanations);
        this.shards = builder.shards;
        this.valid = Objects.requireNonNull(builder.valid, "valid");
        this.error = builder.error;
    }

    public ValidateQueryResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<IndicesValidationExplanation> explanations() {
        return this.explanations;
    }

    @Nullable
    public ShardStatistics shards() {
        return this.shards;
    }

    public boolean valid() {
        return this.valid;
    }

    @Nullable
    public String error() {
        return this.error;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.explanations != null) {
            generator.writeKey("explanations");
            generator.writeStartArray();
            for (IndicesValidationExplanation item0 : this.explanations) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.shards != null) {
            generator.writeKey("_shards");
            this.shards.serialize(generator, mapper);
        }
        generator.writeKey("valid");
        generator.write(this.valid);
        if (this.error != null) {
            generator.writeKey("error");
            generator.write(this.error);
        }
    }

    protected static void setupValidateQueryResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::explanations, JsonpDeserializer.arrayDeserializer(IndicesValidationExplanation._DESERIALIZER), "explanations", new String[0]);
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
        op.add(Builder::valid, JsonpDeserializer.booleanDeserializer(), "valid", new String[0]);
        op.add(Builder::error, JsonpDeserializer.stringDeserializer(), "error", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ValidateQueryResponse> {
        @Nullable
        private List<IndicesValidationExplanation> explanations;
        @Nullable
        private ShardStatistics shards;
        private Boolean valid;
        @Nullable
        private String error;

        public Builder explanations(@Nullable List<IndicesValidationExplanation> value) {
            this.explanations = value;
            return this;
        }

        public Builder explanations(IndicesValidationExplanation ... value) {
            this.explanations = Arrays.asList(value);
            return this;
        }

        public Builder addExplanations(IndicesValidationExplanation value) {
            if (this.explanations == null) {
                this.explanations = new ArrayList<IndicesValidationExplanation>();
            }
            this.explanations.add(value);
            return this;
        }

        public Builder explanations(Function<IndicesValidationExplanation.Builder, ObjectBuilder<IndicesValidationExplanation>> fn) {
            return this.explanations(fn.apply(new IndicesValidationExplanation.Builder()).build());
        }

        public Builder addExplanations(Function<IndicesValidationExplanation.Builder, ObjectBuilder<IndicesValidationExplanation>> fn) {
            return this.addExplanations(fn.apply(new IndicesValidationExplanation.Builder()).build());
        }

        public Builder shards(@Nullable ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public Builder valid(boolean value) {
            this.valid = value;
            return this;
        }

        public Builder error(@Nullable String value) {
            this.error = value;
            return this;
        }

        @Override
        public ValidateQueryResponse build() {
            return new ValidateQueryResponse(this);
        }
    }
}

