/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponseBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RolloverResponse
extends AcknowledgedResponseBase {
    private final Map<String, Boolean> conditions;
    private final boolean dryRun;
    private final String newIndex;
    private final String oldIndex;
    private final boolean rolledOver;
    private final boolean shardsAcknowledged;
    public static final JsonpDeserializer<RolloverResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RolloverResponse::setupRolloverResponseDeserializer, Builder::build);

    public RolloverResponse(Builder builder) {
        super(builder);
        this.conditions = ModelTypeHelper.unmodifiableNonNull(builder.conditions, "conditions");
        this.dryRun = Objects.requireNonNull(builder.dryRun, "dry_run");
        this.newIndex = Objects.requireNonNull(builder.newIndex, "new_index");
        this.oldIndex = Objects.requireNonNull(builder.oldIndex, "old_index");
        this.rolledOver = Objects.requireNonNull(builder.rolledOver, "rolled_over");
        this.shardsAcknowledged = Objects.requireNonNull(builder.shardsAcknowledged, "shards_acknowledged");
    }

    public RolloverResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, Boolean> conditions() {
        return this.conditions;
    }

    public boolean dryRun() {
        return this.dryRun;
    }

    public String newIndex() {
        return this.newIndex;
    }

    public String oldIndex() {
        return this.oldIndex;
    }

    public boolean rolledOver() {
        return this.rolledOver;
    }

    public boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("conditions");
        generator.writeStartObject();
        for (Map.Entry<String, Boolean> item0 : this.conditions.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue().booleanValue());
        }
        generator.writeEnd();
        generator.writeKey("dry_run");
        generator.write(this.dryRun);
        generator.writeKey("new_index");
        generator.write(this.newIndex);
        generator.writeKey("old_index");
        generator.write(this.oldIndex);
        generator.writeKey("rolled_over");
        generator.write(this.rolledOver);
        generator.writeKey("shards_acknowledged");
        generator.write(this.shardsAcknowledged);
    }

    protected static void setupRolloverResponseDeserializer(DelegatingDeserializer<Builder> op) {
        AcknowledgedResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::conditions, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.booleanDeserializer()), "conditions", new String[0]);
        op.add(Builder::dryRun, JsonpDeserializer.booleanDeserializer(), "dry_run", new String[0]);
        op.add(Builder::newIndex, JsonpDeserializer.stringDeserializer(), "new_index", new String[0]);
        op.add(Builder::oldIndex, JsonpDeserializer.stringDeserializer(), "old_index", new String[0]);
        op.add(Builder::rolledOver, JsonpDeserializer.booleanDeserializer(), "rolled_over", new String[0]);
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged", new String[0]);
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RolloverResponse> {
        private Map<String, Boolean> conditions;
        private Boolean dryRun;
        private String newIndex;
        private String oldIndex;
        private Boolean rolledOver;
        private Boolean shardsAcknowledged;

        public Builder conditions(Map<String, Boolean> value) {
            this.conditions = value;
            return this;
        }

        public Builder putConditions(String key, Boolean value) {
            if (this.conditions == null) {
                this.conditions = new HashMap<String, Boolean>();
            }
            this.conditions.put(key, value);
            return this;
        }

        public Builder dryRun(boolean value) {
            this.dryRun = value;
            return this;
        }

        public Builder newIndex(String value) {
            this.newIndex = value;
            return this;
        }

        public Builder oldIndex(String value) {
            this.oldIndex = value;
            return this;
        }

        public Builder rolledOver(boolean value) {
            this.rolledOver = value;
            return this;
        }

        public Builder shardsAcknowledged(boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RolloverResponse build() {
            return new RolloverResponse(this);
        }
    }
}

