/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.graph.VertexDefinition;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Hop
implements JsonpSerializable {
    @Nullable
    private final Hop connections;
    private final Query query;
    private final List<VertexDefinition> vertices;
    public static final JsonpDeserializer<Hop> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Hop::setupHopDeserializer, Builder::build);

    public Hop(Builder builder) {
        this.connections = builder.connections;
        this.query = Objects.requireNonNull(builder.query, "query");
        this.vertices = ModelTypeHelper.unmodifiableNonNull(builder.vertices, "vertices");
    }

    public Hop(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Hop connections() {
        return this.connections;
    }

    public Query query() {
        return this.query;
    }

    public List<VertexDefinition> vertices() {
        return this.vertices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.connections != null) {
            generator.writeKey("connections");
            this.connections.serialize(generator, mapper);
        }
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        generator.writeKey("vertices");
        generator.writeStartArray();
        for (VertexDefinition item0 : this.vertices) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupHopDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::connections, _DESERIALIZER, "connections", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::vertices, JsonpDeserializer.arrayDeserializer(VertexDefinition._DESERIALIZER), "vertices", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Hop> {
        @Nullable
        private Hop connections;
        private Query query;
        private List<VertexDefinition> vertices;

        public Builder connections(@Nullable Hop value) {
            this.connections = value;
            return this;
        }

        public Builder connections(Function<Builder, ObjectBuilder<Hop>> fn) {
            return this.connections(fn.apply(new Builder()).build());
        }

        public Builder query(Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder vertices(List<VertexDefinition> value) {
            this.vertices = value;
            return this;
        }

        public Builder vertices(VertexDefinition ... value) {
            this.vertices = Arrays.asList(value);
            return this;
        }

        public Builder addVertices(VertexDefinition value) {
            if (this.vertices == null) {
                this.vertices = new ArrayList<VertexDefinition>();
            }
            this.vertices.add(value);
            return this;
        }

        public Builder vertices(Function<VertexDefinition.Builder, ObjectBuilder<VertexDefinition>> fn) {
            return this.vertices(fn.apply(new VertexDefinition.Builder()).build());
        }

        public Builder addVertices(Function<VertexDefinition.Builder, ObjectBuilder<VertexDefinition>> fn) {
            return this.addVertices(fn.apply(new VertexDefinition.Builder()).build());
        }

        @Override
        public Hop build() {
            return new Hop(this);
        }
    }
}

