/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich;

import co.elastic.clients.elasticsearch.enrich.stats.CacheStats;
import co.elastic.clients.elasticsearch.enrich.stats.CoordinatorStats;
import co.elastic.clients.elasticsearch.enrich.stats.ExecutingPolicy;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class StatsResponse
implements JsonpSerializable {
    private final List<CoordinatorStats> coordinatorStats;
    private final List<ExecutingPolicy> executingPolicies;
    @Nullable
    private final List<CacheStats> cacheStats;
    public static final JsonpDeserializer<StatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StatsResponse::setupStatsResponseDeserializer, Builder::build);

    public StatsResponse(Builder builder) {
        this.coordinatorStats = ModelTypeHelper.unmodifiableNonNull(builder.coordinatorStats, "coordinator_stats");
        this.executingPolicies = ModelTypeHelper.unmodifiableNonNull(builder.executingPolicies, "executing_policies");
        this.cacheStats = ModelTypeHelper.unmodifiable(builder.cacheStats);
    }

    public StatsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<CoordinatorStats> coordinatorStats() {
        return this.coordinatorStats;
    }

    public List<ExecutingPolicy> executingPolicies() {
        return this.executingPolicies;
    }

    @Nullable
    public List<CacheStats> cacheStats() {
        return this.cacheStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("coordinator_stats");
        generator.writeStartArray();
        for (CoordinatorStats coordinatorStats : this.coordinatorStats) {
            coordinatorStats.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("executing_policies");
        generator.writeStartArray();
        for (ExecutingPolicy executingPolicy : this.executingPolicies) {
            executingPolicy.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.cacheStats != null) {
            generator.writeKey("cache_stats");
            generator.writeStartArray();
            for (CacheStats cacheStats : this.cacheStats) {
                cacheStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupStatsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::coordinatorStats, JsonpDeserializer.arrayDeserializer(CoordinatorStats._DESERIALIZER), "coordinator_stats", new String[0]);
        op.add(Builder::executingPolicies, JsonpDeserializer.arrayDeserializer(ExecutingPolicy._DESERIALIZER), "executing_policies", new String[0]);
        op.add(Builder::cacheStats, JsonpDeserializer.arrayDeserializer(CacheStats._DESERIALIZER), "cache_stats", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<StatsResponse> {
        private List<CoordinatorStats> coordinatorStats;
        private List<ExecutingPolicy> executingPolicies;
        @Nullable
        private List<CacheStats> cacheStats;

        public Builder coordinatorStats(List<CoordinatorStats> value) {
            this.coordinatorStats = value;
            return this;
        }

        public Builder coordinatorStats(CoordinatorStats ... value) {
            this.coordinatorStats = Arrays.asList(value);
            return this;
        }

        public Builder addCoordinatorStats(CoordinatorStats value) {
            if (this.coordinatorStats == null) {
                this.coordinatorStats = new ArrayList<CoordinatorStats>();
            }
            this.coordinatorStats.add(value);
            return this;
        }

        public Builder coordinatorStats(Function<CoordinatorStats.Builder, ObjectBuilder<CoordinatorStats>> fn) {
            return this.coordinatorStats(fn.apply(new CoordinatorStats.Builder()).build());
        }

        public Builder addCoordinatorStats(Function<CoordinatorStats.Builder, ObjectBuilder<CoordinatorStats>> fn) {
            return this.addCoordinatorStats(fn.apply(new CoordinatorStats.Builder()).build());
        }

        public Builder executingPolicies(List<ExecutingPolicy> value) {
            this.executingPolicies = value;
            return this;
        }

        public Builder executingPolicies(ExecutingPolicy ... value) {
            this.executingPolicies = Arrays.asList(value);
            return this;
        }

        public Builder addExecutingPolicies(ExecutingPolicy value) {
            if (this.executingPolicies == null) {
                this.executingPolicies = new ArrayList<ExecutingPolicy>();
            }
            this.executingPolicies.add(value);
            return this;
        }

        public Builder executingPolicies(Function<ExecutingPolicy.Builder, ObjectBuilder<ExecutingPolicy>> fn) {
            return this.executingPolicies(fn.apply(new ExecutingPolicy.Builder()).build());
        }

        public Builder addExecutingPolicies(Function<ExecutingPolicy.Builder, ObjectBuilder<ExecutingPolicy>> fn) {
            return this.addExecutingPolicies(fn.apply(new ExecutingPolicy.Builder()).build());
        }

        public Builder cacheStats(@Nullable List<CacheStats> value) {
            this.cacheStats = value;
            return this;
        }

        public Builder cacheStats(CacheStats ... value) {
            this.cacheStats = Arrays.asList(value);
            return this;
        }

        public Builder addCacheStats(CacheStats value) {
            if (this.cacheStats == null) {
                this.cacheStats = new ArrayList<CacheStats>();
            }
            this.cacheStats.add(value);
            return this;
        }

        public Builder cacheStats(Function<CacheStats.Builder, ObjectBuilder<CacheStats>> fn) {
            return this.cacheStats(fn.apply(new CacheStats.Builder()).build());
        }

        public Builder addCacheStats(Function<CacheStats.Builder, ObjectBuilder<CacheStats>> fn) {
            return this.addCacheStats(fn.apply(new CacheStats.Builder()).build());
        }

        @Override
        public StatsResponse build() {
            return new StatsResponse(this);
        }
    }
}

