/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RuntimeFieldTypes
implements JsonpSerializable {
    private final String name;
    private final int count;
    private final int indexCount;
    private final int scriptlessCount;
    private final int shadowedCount;
    private final List<String> lang;
    private final int linesMax;
    private final int linesTotal;
    private final int charsMax;
    private final int charsTotal;
    private final int sourceMax;
    private final int sourceTotal;
    private final int docMax;
    private final int docTotal;
    public static final JsonpDeserializer<RuntimeFieldTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuntimeFieldTypes::setupRuntimeFieldTypesDeserializer, Builder::build);

    public RuntimeFieldTypes(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.count = Objects.requireNonNull(builder.count, "count");
        this.indexCount = Objects.requireNonNull(builder.indexCount, "index_count");
        this.scriptlessCount = Objects.requireNonNull(builder.scriptlessCount, "scriptless_count");
        this.shadowedCount = Objects.requireNonNull(builder.shadowedCount, "shadowed_count");
        this.lang = ModelTypeHelper.unmodifiableNonNull(builder.lang, "lang");
        this.linesMax = Objects.requireNonNull(builder.linesMax, "lines_max");
        this.linesTotal = Objects.requireNonNull(builder.linesTotal, "lines_total");
        this.charsMax = Objects.requireNonNull(builder.charsMax, "chars_max");
        this.charsTotal = Objects.requireNonNull(builder.charsTotal, "chars_total");
        this.sourceMax = Objects.requireNonNull(builder.sourceMax, "source_max");
        this.sourceTotal = Objects.requireNonNull(builder.sourceTotal, "source_total");
        this.docMax = Objects.requireNonNull(builder.docMax, "doc_max");
        this.docTotal = Objects.requireNonNull(builder.docTotal, "doc_total");
    }

    public RuntimeFieldTypes(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public int count() {
        return this.count;
    }

    public int indexCount() {
        return this.indexCount;
    }

    public int scriptlessCount() {
        return this.scriptlessCount;
    }

    public int shadowedCount() {
        return this.shadowedCount;
    }

    public List<String> lang() {
        return this.lang;
    }

    public int linesMax() {
        return this.linesMax;
    }

    public int linesTotal() {
        return this.linesTotal;
    }

    public int charsMax() {
        return this.charsMax;
    }

    public int charsTotal() {
        return this.charsTotal;
    }

    public int sourceMax() {
        return this.sourceMax;
    }

    public int sourceTotal() {
        return this.sourceTotal;
    }

    public int docMax() {
        return this.docMax;
    }

    public int docTotal() {
        return this.docTotal;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        generator.writeKey("scriptless_count");
        generator.write(this.scriptlessCount);
        generator.writeKey("shadowed_count");
        generator.write(this.shadowedCount);
        generator.writeKey("lang");
        generator.writeStartArray();
        for (String item0 : this.lang) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("lines_max");
        generator.write(this.linesMax);
        generator.writeKey("lines_total");
        generator.write(this.linesTotal);
        generator.writeKey("chars_max");
        generator.write(this.charsMax);
        generator.writeKey("chars_total");
        generator.write(this.charsTotal);
        generator.writeKey("source_max");
        generator.write(this.sourceMax);
        generator.writeKey("source_total");
        generator.write(this.sourceTotal);
        generator.writeKey("doc_max");
        generator.write(this.docMax);
        generator.writeKey("doc_total");
        generator.write(this.docTotal);
    }

    protected static void setupRuntimeFieldTypesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count", new String[0]);
        op.add(Builder::indexCount, JsonpDeserializer.integerDeserializer(), "index_count", new String[0]);
        op.add(Builder::scriptlessCount, JsonpDeserializer.integerDeserializer(), "scriptless_count", new String[0]);
        op.add(Builder::shadowedCount, JsonpDeserializer.integerDeserializer(), "shadowed_count", new String[0]);
        op.add(Builder::lang, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "lang", new String[0]);
        op.add(Builder::linesMax, JsonpDeserializer.integerDeserializer(), "lines_max", new String[0]);
        op.add(Builder::linesTotal, JsonpDeserializer.integerDeserializer(), "lines_total", new String[0]);
        op.add(Builder::charsMax, JsonpDeserializer.integerDeserializer(), "chars_max", new String[0]);
        op.add(Builder::charsTotal, JsonpDeserializer.integerDeserializer(), "chars_total", new String[0]);
        op.add(Builder::sourceMax, JsonpDeserializer.integerDeserializer(), "source_max", new String[0]);
        op.add(Builder::sourceTotal, JsonpDeserializer.integerDeserializer(), "source_total", new String[0]);
        op.add(Builder::docMax, JsonpDeserializer.integerDeserializer(), "doc_max", new String[0]);
        op.add(Builder::docTotal, JsonpDeserializer.integerDeserializer(), "doc_total", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RuntimeFieldTypes> {
        private String name;
        private Integer count;
        private Integer indexCount;
        private Integer scriptlessCount;
        private Integer shadowedCount;
        private List<String> lang;
        private Integer linesMax;
        private Integer linesTotal;
        private Integer charsMax;
        private Integer charsTotal;
        private Integer sourceMax;
        private Integer sourceTotal;
        private Integer docMax;
        private Integer docTotal;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder count(int value) {
            this.count = value;
            return this;
        }

        public Builder indexCount(int value) {
            this.indexCount = value;
            return this;
        }

        public Builder scriptlessCount(int value) {
            this.scriptlessCount = value;
            return this;
        }

        public Builder shadowedCount(int value) {
            this.shadowedCount = value;
            return this;
        }

        public Builder lang(List<String> value) {
            this.lang = value;
            return this;
        }

        public Builder lang(String ... value) {
            this.lang = Arrays.asList(value);
            return this;
        }

        public Builder addLang(String value) {
            if (this.lang == null) {
                this.lang = new ArrayList<String>();
            }
            this.lang.add(value);
            return this;
        }

        public Builder linesMax(int value) {
            this.linesMax = value;
            return this;
        }

        public Builder linesTotal(int value) {
            this.linesTotal = value;
            return this;
        }

        public Builder charsMax(int value) {
            this.charsMax = value;
            return this;
        }

        public Builder charsTotal(int value) {
            this.charsTotal = value;
            return this;
        }

        public Builder sourceMax(int value) {
            this.sourceMax = value;
            return this;
        }

        public Builder sourceTotal(int value) {
            this.sourceTotal = value;
            return this;
        }

        public Builder docMax(int value) {
            this.docMax = value;
            return this;
        }

        public Builder docTotal(int value) {
            this.docTotal = value;
            return this;
        }

        @Override
        public RuntimeFieldTypes build() {
            return new RuntimeFieldTypes(this);
        }
    }
}

