/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.ClusterJvmMemory;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterJvmVersion;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ClusterJvm
implements JsonpSerializable {
    private final long maxUptimeInMillis;
    private final ClusterJvmMemory mem;
    private final long threads;
    private final List<ClusterJvmVersion> versions;
    public static final JsonpDeserializer<ClusterJvm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterJvm::setupClusterJvmDeserializer, Builder::build);

    public ClusterJvm(Builder builder) {
        this.maxUptimeInMillis = Objects.requireNonNull(builder.maxUptimeInMillis, "max_uptime_in_millis");
        this.mem = Objects.requireNonNull(builder.mem, "mem");
        this.threads = Objects.requireNonNull(builder.threads, "threads");
        this.versions = ModelTypeHelper.unmodifiableNonNull(builder.versions, "versions");
    }

    public ClusterJvm(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long maxUptimeInMillis() {
        return this.maxUptimeInMillis;
    }

    public ClusterJvmMemory mem() {
        return this.mem;
    }

    public long threads() {
        return this.threads;
    }

    public List<ClusterJvmVersion> versions() {
        return this.versions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max_uptime_in_millis");
        generator.write(this.maxUptimeInMillis);
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        generator.writeKey("threads");
        generator.write(this.threads);
        generator.writeKey("versions");
        generator.writeStartArray();
        for (ClusterJvmVersion item0 : this.versions) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupClusterJvmDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::maxUptimeInMillis, JsonpDeserializer.longDeserializer(), "max_uptime_in_millis", new String[0]);
        op.add(Builder::mem, ClusterJvmMemory._DESERIALIZER, "mem", new String[0]);
        op.add(Builder::threads, JsonpDeserializer.longDeserializer(), "threads", new String[0]);
        op.add(Builder::versions, JsonpDeserializer.arrayDeserializer(ClusterJvmVersion._DESERIALIZER), "versions", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterJvm> {
        private Long maxUptimeInMillis;
        private ClusterJvmMemory mem;
        private Long threads;
        private List<ClusterJvmVersion> versions;

        public Builder maxUptimeInMillis(long value) {
            this.maxUptimeInMillis = value;
            return this;
        }

        public Builder mem(ClusterJvmMemory value) {
            this.mem = value;
            return this;
        }

        public Builder mem(Function<ClusterJvmMemory.Builder, ObjectBuilder<ClusterJvmMemory>> fn) {
            return this.mem(fn.apply(new ClusterJvmMemory.Builder()).build());
        }

        public Builder threads(long value) {
            this.threads = value;
            return this;
        }

        public Builder versions(List<ClusterJvmVersion> value) {
            this.versions = value;
            return this;
        }

        public Builder versions(ClusterJvmVersion ... value) {
            this.versions = Arrays.asList(value);
            return this;
        }

        public Builder addVersions(ClusterJvmVersion value) {
            if (this.versions == null) {
                this.versions = new ArrayList<ClusterJvmVersion>();
            }
            this.versions.add(value);
            return this;
        }

        public Builder versions(Function<ClusterJvmVersion.Builder, ObjectBuilder<ClusterJvmVersion>> fn) {
            return this.versions(fn.apply(new ClusterJvmVersion.Builder()).build());
        }

        public Builder addVersions(Function<ClusterJvmVersion.Builder, ObjectBuilder<ClusterJvmVersion>> fn) {
            return this.addVersions(fn.apply(new ClusterJvmVersion.Builder()).build());
        }

        @Override
        public ClusterJvm build() {
            return new ClusterJvm(this);
        }
    }
}

