/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.allocation_explain;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DiskUsage
implements JsonpSerializable {
    private final String path;
    private final long totalBytes;
    private final long usedBytes;
    private final long freeBytes;
    private final double freeDiskPercent;
    private final double usedDiskPercent;
    public static final JsonpDeserializer<DiskUsage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DiskUsage::setupDiskUsageDeserializer, Builder::build);

    public DiskUsage(Builder builder) {
        this.path = Objects.requireNonNull(builder.path, "path");
        this.totalBytes = Objects.requireNonNull(builder.totalBytes, "total_bytes");
        this.usedBytes = Objects.requireNonNull(builder.usedBytes, "used_bytes");
        this.freeBytes = Objects.requireNonNull(builder.freeBytes, "free_bytes");
        this.freeDiskPercent = Objects.requireNonNull(builder.freeDiskPercent, "free_disk_percent");
        this.usedDiskPercent = Objects.requireNonNull(builder.usedDiskPercent, "used_disk_percent");
    }

    public DiskUsage(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String path() {
        return this.path;
    }

    public long totalBytes() {
        return this.totalBytes;
    }

    public long usedBytes() {
        return this.usedBytes;
    }

    public long freeBytes() {
        return this.freeBytes;
    }

    public double freeDiskPercent() {
        return this.freeDiskPercent;
    }

    public double usedDiskPercent() {
        return this.usedDiskPercent;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("path");
        generator.write(this.path);
        generator.writeKey("total_bytes");
        generator.write(this.totalBytes);
        generator.writeKey("used_bytes");
        generator.write(this.usedBytes);
        generator.writeKey("free_bytes");
        generator.write(this.freeBytes);
        generator.writeKey("free_disk_percent");
        generator.write(this.freeDiskPercent);
        generator.writeKey("used_disk_percent");
        generator.write(this.usedDiskPercent);
    }

    protected static void setupDiskUsageDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path", new String[0]);
        op.add(Builder::totalBytes, JsonpDeserializer.longDeserializer(), "total_bytes", new String[0]);
        op.add(Builder::usedBytes, JsonpDeserializer.longDeserializer(), "used_bytes", new String[0]);
        op.add(Builder::freeBytes, JsonpDeserializer.longDeserializer(), "free_bytes", new String[0]);
        op.add(Builder::freeDiskPercent, JsonpDeserializer.doubleDeserializer(), "free_disk_percent", new String[0]);
        op.add(Builder::usedDiskPercent, JsonpDeserializer.doubleDeserializer(), "used_disk_percent", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DiskUsage> {
        private String path;
        private Long totalBytes;
        private Long usedBytes;
        private Long freeBytes;
        private Double freeDiskPercent;
        private Double usedDiskPercent;

        public Builder path(String value) {
            this.path = value;
            return this;
        }

        public Builder totalBytes(long value) {
            this.totalBytes = value;
            return this;
        }

        public Builder usedBytes(long value) {
            this.usedBytes = value;
            return this;
        }

        public Builder freeBytes(long value) {
            this.freeBytes = value;
            return this;
        }

        public Builder freeDiskPercent(double value) {
            this.freeDiskPercent = value;
            return this;
        }

        public Builder usedDiskPercent(double value) {
            this.usedDiskPercent = value;
            return this;
        }

        @Override
        public DiskUsage build() {
            return new DiskUsage(this);
        }
    }
}

