/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.cluster.RerouteResponse;
import co.elastic.clients.elasticsearch.cluster.reroute.Command;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RerouteRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean dryRun;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final List<String> metric;
    @Nullable
    private final Boolean retryFailed;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    @Nullable
    private final List<Command> commands;
    public static final JsonpDeserializer<RerouteRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerouteRequest::setupRerouteRequestDeserializer, Builder::build);
    public static final Endpoint<RerouteRequest, RerouteResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<RerouteRequest, RerouteResponse>(request -> "POST", request -> "/_cluster/reroute", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.dryRun != null) {
            params.put("dry_run", String.valueOf(request.dryRun));
        }
        if (request.explain != null) {
            params.put("explain", String.valueOf(request.explain));
        }
        if (request.metric != null) {
            params.put("metric", request.metric.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.retryFailed != null) {
            params.put("retry_failed", String.valueOf(request.retryFailed));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, RerouteResponse._DESERIALIZER);

    public RerouteRequest(Builder builder) {
        this.dryRun = builder.dryRun;
        this.explain = builder.explain;
        this.metric = ModelTypeHelper.unmodifiable(builder.metric);
        this.retryFailed = builder.retryFailed;
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.commands = ModelTypeHelper.unmodifiable(builder.commands);
    }

    public RerouteRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean dryRun() {
        return this.dryRun;
    }

    @Nullable
    public Boolean explain() {
        return this.explain;
    }

    @Nullable
    public List<String> metric() {
        return this.metric;
    }

    @Nullable
    public Boolean retryFailed() {
        return this.retryFailed;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public List<Command> commands() {
        return this.commands;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.commands != null) {
            generator.writeKey("commands");
            generator.writeStartArray();
            for (Command item0 : this.commands) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRerouteRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::commands, JsonpDeserializer.arrayDeserializer(Command._DESERIALIZER), "commands", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RerouteRequest> {
        @Nullable
        private Boolean dryRun;
        @Nullable
        private Boolean explain;
        @Nullable
        private List<String> metric;
        @Nullable
        private Boolean retryFailed;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;
        @Nullable
        private List<Command> commands;

        public Builder dryRun(@Nullable Boolean value) {
            this.dryRun = value;
            return this;
        }

        public Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public Builder metric(@Nullable List<String> value) {
            this.metric = value;
            return this;
        }

        public Builder metric(String ... value) {
            this.metric = Arrays.asList(value);
            return this;
        }

        public Builder addMetric(String value) {
            if (this.metric == null) {
                this.metric = new ArrayList<String>();
            }
            this.metric.add(value);
            return this;
        }

        public Builder retryFailed(@Nullable Boolean value) {
            this.retryFailed = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder commands(@Nullable List<Command> value) {
            this.commands = value;
            return this;
        }

        public Builder commands(Command ... value) {
            this.commands = Arrays.asList(value);
            return this;
        }

        public Builder addCommands(Command value) {
            if (this.commands == null) {
                this.commands = new ArrayList<Command>();
            }
            this.commands.add(value);
            return this;
        }

        public Builder commands(Function<Command.Builder, ObjectBuilder<Command>> fn) {
            return this.commands(fn.apply(new Command.Builder()).build());
        }

        public Builder addCommands(Function<Command.Builder, ObjectBuilder<Command>> fn) {
            return this.addCommands(fn.apply(new Command.Builder()).build());
        }

        @Override
        public RerouteRequest build() {
            return new RerouteRequest(this);
        }
    }
}

