/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.Level;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.WaitForEvents;
import co.elastic.clients.elasticsearch._types.WaitForStatus;
import co.elastic.clients.elasticsearch.cluster.HealthResponse;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class HealthRequest
extends RequestBase {
    @Nullable
    private final List<String> index;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Level level;
    @Nullable
    private final Boolean local;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    @Nullable
    private final JsonValue waitForActiveShards;
    @Nullable
    private final WaitForEvents waitForEvents;
    @Nullable
    private final String waitForNodes;
    @Nullable
    private final Boolean waitForNoInitializingShards;
    @Nullable
    private final Boolean waitForNoRelocatingShards;
    @Nullable
    private final WaitForStatus waitForStatus;
    public static final Endpoint<HealthRequest, HealthResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<HealthRequest, HealthResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster");
            buf.append("/health");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster");
            buf.append("/health");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.level != null) {
            params.put("level", request.level.toString());
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", JsonpUtils.toString(request.waitForActiveShards));
        }
        if (request.waitForEvents != null) {
            params.put("wait_for_events", request.waitForEvents.toString());
        }
        if (request.waitForNodes != null) {
            params.put("wait_for_nodes", request.waitForNodes);
        }
        if (request.waitForNoInitializingShards != null) {
            params.put("wait_for_no_initializing_shards", String.valueOf(request.waitForNoInitializingShards));
        }
        if (request.waitForNoRelocatingShards != null) {
            params.put("wait_for_no_relocating_shards", String.valueOf(request.waitForNoRelocatingShards));
        }
        if (request.waitForStatus != null) {
            params.put("wait_for_status", request.waitForStatus.toString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, HealthResponse._DESERIALIZER);

    public HealthRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.level = builder.level;
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.waitForActiveShards = builder.waitForActiveShards;
        this.waitForEvents = builder.waitForEvents;
        this.waitForNodes = builder.waitForNodes;
        this.waitForNoInitializingShards = builder.waitForNoInitializingShards;
        this.waitForNoRelocatingShards = builder.waitForNoRelocatingShards;
        this.waitForStatus = builder.waitForStatus;
    }

    public HealthRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Level level() {
        return this.level;
    }

    @Nullable
    public Boolean local() {
        return this.local;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public JsonValue waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public WaitForEvents waitForEvents() {
        return this.waitForEvents;
    }

    @Nullable
    public String waitForNodes() {
        return this.waitForNodes;
    }

    @Nullable
    public Boolean waitForNoInitializingShards() {
        return this.waitForNoInitializingShards;
    }

    @Nullable
    public Boolean waitForNoRelocatingShards() {
        return this.waitForNoRelocatingShards;
    }

    @Nullable
    public WaitForStatus waitForStatus() {
        return this.waitForStatus;
    }

    public static class Builder
    implements ObjectBuilder<HealthRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Level level;
        @Nullable
        private Boolean local;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;
        @Nullable
        private JsonValue waitForActiveShards;
        @Nullable
        private WaitForEvents waitForEvents;
        @Nullable
        private String waitForNodes;
        @Nullable
        private Boolean waitForNoInitializingShards;
        @Nullable
        private Boolean waitForNoRelocatingShards;
        @Nullable
        private WaitForStatus waitForStatus;

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder level(@Nullable Level value) {
            this.level = value;
            return this;
        }

        public Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder waitForActiveShards(@Nullable JsonValue value) {
            this.waitForActiveShards = value;
            return this;
        }

        public Builder waitForEvents(@Nullable WaitForEvents value) {
            this.waitForEvents = value;
            return this;
        }

        public Builder waitForNodes(@Nullable String value) {
            this.waitForNodes = value;
            return this;
        }

        public Builder waitForNoInitializingShards(@Nullable Boolean value) {
            this.waitForNoInitializingShards = value;
            return this;
        }

        public Builder waitForNoRelocatingShards(@Nullable Boolean value) {
            this.waitForNoRelocatingShards = value;
            return this;
        }

        public Builder waitForStatus(@Nullable WaitForStatus value) {
            this.waitForStatus = value;
            return this;
        }

        @Override
        public HealthRequest build() {
            return new HealthRequest(this);
        }
    }
}

