/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.cluster.GetComponentTemplateResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetComponentTemplateRequest
extends RequestBase {
    @Nullable
    private final String name;
    @Nullable
    private final Boolean flatSettings;
    @Nullable
    private final Boolean local;
    @Nullable
    private final String masterTimeout;
    public static final Endpoint<GetComponentTemplateRequest, GetComponentTemplateResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetComponentTemplateRequest, GetComponentTemplateResponse>(request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_component_template");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_component_template");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.flatSettings != null) {
            params.put("flat_settings", String.valueOf(request.flatSettings));
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetComponentTemplateResponse._DESERIALIZER);

    public GetComponentTemplateRequest(Builder builder) {
        this.name = builder.name;
        this.flatSettings = builder.flatSettings;
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
    }

    public GetComponentTemplateRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nullable
    public Boolean local() {
        return this.local;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    public static class Builder
    implements ObjectBuilder<GetComponentTemplateRequest> {
        @Nullable
        private String name;
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private Boolean local;
        @Nullable
        private String masterTimeout;

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        public Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        @Override
        public GetComponentTemplateRequest build() {
            return new GetComponentTemplateRequest(this);
        }
    }
}

